function fillSphTri(N,x,y,z,varargin)
% function fillSphTri(N,x,y,z,varargin)
%
% Create a filled polygon with the edges between 
% the sets of points replaced by great circles
% with N incremental points. The remainder of the arguments
% are identical to fill3.
%
% (C)opyright 2005, Bennett Landman, bennett@bme.jhu.edu
% Revision History:
% Created: 2/11/2005

r = sqrt(x(1)^2+y(1)^2+z(1)^2);
d = linspace(0,1,N+2);
x1 = [];
y1 = [];
z1 = [];

for k=1:(length(x)-1)
    for m=1:length(d)
        x1(end+1) = x(k)*(1-d(m))+x(k+1)*d(m);
        y1(end+1) = y(k)*(1-d(m))+y(k+1)*d(m);
        z1(end+1) = z(k)*(1-d(m))+z(k+1)*d(m);
    end
end

[th,phi,r0]=cart2sph(x1,y1,z1);
[x1,y1,z1] = sph2cart(th,phi,r);
fill3(x1,y1,z1,varargin{:});