function X = forceToSphere(X,r)
% function X = forceToSphere(X,r)
%
% Project the points X to the surface of a sphere of 
% radius r with [0,0,0] as the origin and center of projection.
%
% (C)opyright 2005, Bennett Landman, bennett@bme.jhu.edu
% Revision History:
% Created: 2/11/2005
if(~exist('r')) r=1; end
[th,phi,R] = cart2sph(X(:,1),X(:,2),X(:,3));
[x,y,z] = sph2cart(th,phi,r.*ones(size(th)));
X = [x y z];