function [XA,XB] = intersectLineSphere(R,X0,SLOPE)
% function [XA,XB] = intersectLineSphere(R,X0,SLOPE)
% 
% Find the two points of intersection of a line defined by
% X0+u*SLOPE and a R unit radius sphere centered at 0. Complex
% results will be return if there are no real points of intersection.
%
% (C)opyright 2005, Bennett Landman, bennett@bme.jhu.edu
% Revision History:
% Created: 2/11/2005

% two points on line
x1=X0(1);
y1 =X0(2);
z1 =X0(3);
x2 = X0(1)-SLOPE(1);
y2 = X0(2)-SLOPE(2);
z2 = X0(3)-SLOPE(3);
% Center of sphere
x3 = 0;
y3 = 0;
z3 = 0;
a = (x2 - x1)^2 + (y2 - y1)^2 + (z2 - z1)^2 ;
b = 2*( (x2 - x1)*(x1 - x3) + (y2 - y1)*(y1 - y3) + (z2 - z1)*(z1 - z3) ); 

c = x3^2 + y3^2 + z3^2 + x1^2 + y1^2 + z1^2 - 2*(x3*x1 + y3*y1 + z3*z1) - R^2 ;

up = (-b+sqrt(b^2-4*a*c))/(2*a);
um = (-b-sqrt(b^2-4*a*c))/(2*a);

XA = X0+SLOPE*up;
XB = X0+SLOPE*um;