function [x,y,z,E] = optSymPtsOnSphere_montecarlo2(x,y,z,iters,T,levels,levelwt, forceMetric)
% function [x,y,z,E] =
% optSymPtsOnSphere_montecarlo2(x,y,z,iters,T,levels,levelwt, errorMetric)
%
% Monte Carlo optimization of points on a sphere. From the initial set of
% points (x,y,z), follow a monte carlo optimization technique based on
% brownian motion. 
% 
% The optimization will proceed for iters iterations with a "temperature
% factor" of T. Levels and levelwt are parameters for the errorMetric
% function argument that computes the gradient and energy fcn. (See
% electricForceHeir.m)
% 
% (C)opyright 2005, Bennett Landman, bennett@bme.jhu.edu
% Revision History:
% Created: 2/11/2005
pts = length(x);
Kb = 1.3806503E-23;


[F,E] = forceMetric(x,y,z,levels,levelwt);

bestx = x;
besty=y;
bestz=z;
bestE = E;

for iter=1:iters
    oldx=x;
    oldy=y;
    oldz=z;
    oldE = E;
    changePt = floor(rand(1)*pts)+1;
    [x(changePt),y(changePt),z(changePt)] = randPtsOnSphere(1);
    
    
    [F,E] = forceMetric(x,y,z,levels,levelwt);

    if(E>oldE)
        p = exp(-(E-oldE)/(Kb * T));
        if(p<rand(1))
            x =oldx;
            y=oldy;
            z=oldz;
            E=oldE;
        end
    end


    if(E<bestE)        
        bestE=E;
        bestx = x;
        besty=y;
        bestz=z;
    end

end

x=bestx;
y=besty;
z=bestz;

[F,E] = forceMetric(x,y,z,levels,levelwt);
