function plotDelaunay(x,y,z,TRI,myAlpha,map)
% function plotDelaunay(x,y,z,TRI, myAlpha, map)
% 
% Plot an attractive view of a delaunay tesselation using the colormap in
% map (optional) to weight color by sphereical polygon area. myAlpha is the
% patch opacity (optional, .8 default);.
% 
% (C)opyright 2005, Bennett Landman, bennett@bme.jhu.edu
% Revision History:
% Created: 2/11/2005
% Updated: 2/14/2005 Updated spherical polygon rendering
R = epsunique(10,sqrt(x.^2+y.^2+z.^2));
if(length(epsunique(10,[1 R]))>1)
    warning('Points do not lie on the surface of a unit sphere within working precision.');
    [X] = forceToSphere([x(:) y(:) z(:)]);
    x = X(:,1)';
    y = X(:,2)';
    z = X(:,3)';
end
if(~exist('myAlpha'))
    myAlpha = .8;
end
if(~exist('map'))
    map = cool(100);
end
if(~exist('TRI'))
    TRI = delaunaySphere(x,y,z);
end
area = sphTriArea(x(TRI),y(TRI),z(TRI));
for j=1:length(TRI)   
    pts = [TRI(j,:) TRI(j,1)];
    clridx = floor(area(j)/max(area)*(-1+size(map,1)))+1;
    fillPolySph(5,x(pts),y(pts),z(pts),map(clridx,:),'FaceAlpha',myAlpha);
    hold on;
end
axis off;
axis equal;
set(gcf,'Color',[1 1 1]);
hold off;
