function plotSymPtsOnSphere(x,y,z,levels)
% function plotSymPtsOnSphere(x,y,z,levels)
%
% Plot the points (x,y,z) and (-x,-y,-z) on a unit sphere
% using levels number of heirarchical levels. Heirarchical divisions are
% defined in linear order. E.g., the first half is the first set of
% level2, and the first quarter is the first set of level 3. 
%
% Unique symbols and colors are used to denote the heirarchical
% relationships. Levels =1,2,3 are currently supported. 
%
% (C)opyright 2005, Bennett Landman, bennett@bme.jhu.edu
% Revision History:
% Created: 2/11/2005

[X,Y,Z] = sphere;
mesh(X*.99,Y*.99,Z*.99); hold on;
clrs = {'rs','bd','rx','g+','c+','m+','cx','mx'};
k=1;
pts = length(x);
for j=1
    inc = 1:(pts/2^(levels-j));
    off = min(inc)-1;
    while(off<pts)
        plot3([x(inc+off) -x(inc+off)],[y(inc+off) -y(inc+off)],[z(inc+off) -z(inc+off)],clrs{k}); k=k+1;
        off = off+max(inc);
    end


end
axis equal;
axis off;
hold off;