function plotVoronoi(x,y,z,VORPOLY, myAlpha, map)
% function plotVoronoi(x,y,z,VORPOLY, myAlpha, map)
%
% Plot an attractive view of a voronoi tesselation using the colormap in
% map (optional) to weight color by sphereical polygon area. myAlpha is the
% patch opacity (optional, .8 default);.
%
% (C)opyright 2005, Bennett Landman, bennett@bme.jhu.edu
% Revision History:
% Created: 2/11/2005
% Updated: 2/14/2005 Updated spherical polygon rendering
% Bug: Allowed points that are not in polygon (return empty triangle)

if(length(epsunique(10,[1 x.^2+y.^2+z.^2]))>1)
    warning('Points do not lie on the surface of a unit sphere within working precision.');
    [X] = forceToSphere([x(:) y(:) z(:)]);
    x = X(:,1)';
    y = X(:,2)';
    z = X(:,3)';
end

if(~exist('VORPOLY'))
    VORPOLY = voronoiSphere(x,y,z);
end
if(isempty(VORPOLY))
    VORPOLY = voronoiSphere(x,y,z);
end
if(~exist('myAlpha'))
    myAlpha = .8;
end
if(~exist('map'))
    map = cool(100);
end
VArea = [];
for j=1:length(VORPOLY)
    Xpt =  [x(j) y(j) z(j)];
    Vpts = VORPOLY{j};
    if(length(Vpts)>0)
        VArea(j) = real(sphPolyArea(Xpt,Vpts));
    end
end


for j=1:length(VORPOLY)
    clridx = floor(VArea(j)/max(VArea)*(-1+size(map,1)))+1;
    Vpts = VORPOLY{j};
    if(length(Vpts)>0)
        fillPolySph(5,Vpts([1:end 1],1), Vpts([1:end 1],2), Vpts([1:end 1],3),map(clridx,:),'FaceAlpha',myAlpha);
        hold on;
        h = plot3(x(j),y(j),z(j),'.');
        set(h,'MarkerEdgeColor',[0 0 0]);
        hold on;
    end
end
axis off;
axis equal;
set(gcf,'Color',[1 1 1]);
hold off;