function ang = vectAng(v1,v2,normalized)
% May 15, 2005 - Updated to support 2D arrays of vectors, should work with
% N D
d = length(size(v1));

if(~exist('normalized'))
    normalized=0;
end
if(~normalized)
dv1 = sqrt(sum(v1.*v1,d));
if(dv1==0)
    ang=NaN;
    return;
end
dv2 = sqrt(sum(v2.*v2,d));
if(dv2==0)
    ang=NaN;
    return;
end
warning off MATLAB:divideByZero
R = ones([1 d]);
R(end) = size(v1,d);
v1 = v1./repmat(dv1,R);
    %v2 = v2./repmat(sqrt(sum(v2.*v2,d)), [ones([1 d-1]) size(v1,d)]);
    v2 = v2./repmat(dv2,R);
warning on MATLAB:divideByZero
end

ang = real(acos(sum(v1.*v2,d)));
