package bl.diffusion;



/**
 * Created by IntelliJ IDEA.
 * User: bennett
 * Date: Nov 20, 2005
 * Time: 9:49:11 AM
 * To change this template use Options | File Templates.
 * ************************************
 * Magnetic Resonance in Medicine Final Project
 * Released: December 1, 2005
 *
 * class SimCompartment
 *      Represent a bounded diffusion compartment/region
 *
 * Copyright (C) 2005 Bennett Landman, bennett@bme.jhu.edu
 */
public interface SimCompartment {

    
    // detect to see if the compartment contains a point
    public boolean contains(PT p);

    // find the first intersection with the segment from a to b
    public IntersectResult findFirstIntersection(PT a, PT b);

    // return the membrane transmission permeability - us/um
    public double getMembranePermeability();

    // return the compartment diffusion coefficient
    public double getDiffusionCoefficient();

    // return the T2 of the compartment in us
	public double getT2();}
