package bl.diffusion;

import java.util.Iterator;
import java.util.Vector;

public class SimCompartmentUnion implements SimCompartment {

	private Vector myCompartments;
	// the diffusion coefficient in the compartment
	private double diffusionCoefficient;

	// The probability of crossing the membrane - us/um
	private double membranePermeability;

	private static double EPS = 1e-5f;
	private double T2; 
	public double getT2() {return T2;};

	public SimCompartmentUnion(double membranePermeability,
			double diffusionCoefficient, double T2) {
		this.T2=T2;
		myCompartments = new Vector();

//		if(transmissionProbability<0 || transmissionProbability>1)
//			throw new RuntimeException("Invalid transmissionProbability");
		this.membranePermeability = membranePermeability;
		if(diffusionCoefficient<=0)
			throw new RuntimeException("Invalid diffusionCoefficient");
		this.diffusionCoefficient = diffusionCoefficient;
	}

	public void addCompartment(SimCompartment compartment) {
		myCompartments.add(compartment);
	}

	public boolean contains(PT p) {
		if(myCompartments.size()<1)
			return false;
		Iterator i = myCompartments.iterator();
		while(i.hasNext()) {
			SimCompartment next = (SimCompartment)i.next();
			if(next.contains(p))
				return true;
		}		
		return false;
	}


	public IntersectResult findFirstIntersection(PT a, PT b) {
		Iterator i = myCompartments.iterator();
		IntersectResult currentResult = null;

		while(i.hasNext()) {
			SimCompartment next = (SimCompartment)i.next();
			IntersectResult thisResult = next.findFirstIntersection(a, b);
			if(thisResult!=null) {
				if(currentResult==null)
					currentResult=thisResult;
				else if(currentResult.fractionalDistance >= 0 && 
						thisResult.fractionalDistance >= 0 && 
						currentResult.fractionalDistance > thisResult.fractionalDistance)
					currentResult = thisResult;
			}
		}
		if(currentResult==null) 
			return null; 
		if(currentResult.fractionalDistance >1)
			return null;
		PT unitStep = b.minus(a).normalize();
		PT nextA = currentResult.intersectionPoint.plus(unitStep.times(EPS));
		if(contains(nextA) && contains(a)) {
			// 	The found intersection is actually an interior point.
			IntersectResult next =findFirstIntersection(nextA, b);
			if(next==null)
				return next;
			next.fractionalDistance = (double)(currentResult.fractionalDistance+
					next.fractionalDistance*b.minus(nextA).norm()/b.minus(a).norm());
			if(next.fractionalDistance>1)
				return null;
			else 
				return next;
		} else { 
			return currentResult; 
		}
	}

	// return the membrane transmission probability
	public double getMembranePermeability() {
		return membranePermeability;
	}

	// return the compartment diffusion coefficient
	public double getDiffusionCoefficient() {
		return diffusionCoefficient;
	}

}
