package bl.diffusion;

public class SimFGArbitraryWaveform implements SimFiniteGradient {

	private PT gradUnitVector;	
	private double myTimeInc;
	private double [][]myWaveForm;	
	private static double gamma = 267.52e-3; // rad/us/mT
//	private static double factor = 1e-6; // um->m
	
	public SimFGArbitraryWaveform(double timeIncrement, double [][]WaveForm_mTpm) {
		myTimeInc = timeIncrement;
		myWaveForm=WaveForm_mTpm;
	}
	public double getPhaseAccumulation(PT currentPosition, double timeStep) {
		// [[rad/us/mT*m/um*mT/m]*um] * [us]
		double phase=gradUnitVector.dot(currentPosition)*1e-6*timeStep;
//		System.out.println(getClass().getCanonicalName()+"\t"+"TS:"+timeStep+"\t"+currentPosition+"\t"+phase);
//		System.out.println(getClass().getCanonicalName()+"\t"+"TS:"+currentPosition);
		return phase;		
	}
	
	public void setSimTime(double time) {
		int offset = (int)Math.floor(time/myTimeInc);
		if(offset>=myWaveForm[0].length) {
			gradUnitVector = new PT(0,0,0);
		} else {
			gradUnitVector = new PT(gamma*myWaveForm[0][offset],gamma*myWaveForm[1][offset],gamma*myWaveForm[2][offset]);
		}		
//		System.out.println(getClass().getCanonicalName()+"\t"+time+"("+offset+"):"+this+" "+gradUnitVector);
//		System.out.println(getClass().getCanonicalName()+"\t"+time+"("+offset+"):"+this+" "+"pa:"+getPhaseAccumulation(new PT(0,0,5), 1));
	}
}
