function compartmentGeometry = RWScreateCompartmentSphere(T2,intraCompartmentDiffusivity,membranePermeability,center,radius)
% function compartmentGeometry  =
% RWScreateCompartmentSphere(intraCompartmentDiffusivity,membranePermeability,center,radius)
%
%   Create a spherical restriction environment 
%
%   Inputs:
%       T2 - T2 of the compartment in us
%       intraCompartmentDiffusivity - intra-compartment diffusivity um2/us
%       membranePermeability - um/us
%       center - center of the sphere in um (does not need to be within lattice)
%       radius - radius of the sphere in um
%       numSpinPackets - number of spins to place
%
%   Outputs:
%       compartmentGometry - an object to describe the compartment
%       geometry.
% ***********************************************
% RandomWalkSimulator v2.0
% Major Revision by:
% 	Bennett Landman, landman@jhu.edu
% 	Jonathan Farrell, jfarrell@jhu.edu
%   (C) Copyright 2008, Bennett Landman and Jonathan Farrell
%   Released under Lessor GNU Public License v1.0
% 	Not for clinical use.
% 	No warranty expressed or implied.
%   Use at your own risk.
% Download at: http://www.nitrc.org/projects/randomwalks/
% ***********************************************
% 9/11/08 bl

import bl.diffusion.*;
compartmentGeometry.javaObject = SimCompartmentSphere(PT(center(1),center(2),center(3)), radius, membranePermeability,intraCompartmentDiffusivity,T2);
compartmentGeometry.name= 'Sphere (analytic)';
compartmentGeometry.diffusivity=intraCompartmentDiffusivity;
compartmentGeometry.permeability=membranePermeability;
[X,Y,Z]=ndgrid(linspace(center(1)-radius-0.1,center(1)+radius+.1,21),...
    linspace(center(2)-radius-.1,center(2)+radius+.1,21),...
    linspace(center(3)-radius-.1,center(3)+radius+.1,21));
V = smooth3(smooth3(sqrt((X-center(1)).^2+(Y-center(2)).^2+(Z-center(3)).^2)<=radius));
compartmentGeometry.shape=isosurface(X,Y,Z,V,0.5);

      
