function handles = RWSshowGeometry(geometry,lattice,colormap)
% function handles = RWSshowGeometry(geometry,lattice,colormap)
%
%   Show a 3D rendering of the specified restriction environment. 
%
%   Inputs:
%       geometry - a geometry object returned by RWSaddCompartment. 
%       lattice - bounding volume of the repeating volume in um
%       
%
%   Outputs:
%       compartmentGometry - an object to describe the compartment
%       geometry.
% ***********************************************
% RandomWalkSimulator v2.0
% Major Revision by:
% 	Bennett Landman, landman@jhu.edu
% 	Jonathan Farrell, jfarrell@jhu.edu
%   (C) Copyright 2008, Bennett Landman and Jonathan Farrell
%   Released under Lessor GNU Public License v1.0
% 	Not for clinical use.
% 	No warranty expressed or implied.
%   Use at your own risk.
% Download at: http://www.nitrc.org/projects/randomwalks/
% ***********************************************
% 9/15/08 bl

if(~exist('colormap','var'))
    colormap=jet(length(geometry));
end
if(~iscell(geometry))
    geo{1} = geometry;
    geometry = geo;
end

for j=1:length(geometry)
    handles(j)=patch(RWSlatticePrune(geometry{j}.shape,lattice),'facecolor',colormap(j,:),'edgecolor','k','edgealpha',.1,'facealpha',0.5);
    hold on;
end

axis equal;
axis([0 lattice(1) 0 lattice(2) 0 lattice(3)])
view(30,45)
grid
handles(end+1)=light;
lighting phong