function h=plotCube(r, clr,varargin)
% plotCube -- plot a 3D cube from -r/2,-r/2,-r/2 to r/2,r/2,r/2
%   h=plotCube(r, clr,varargin)
%       r - location of corner
%       clr - cube color
%       varargin - other options to pass to patch
%       h - image object handles
%
% Copyright (C) 2005 Bennett Landman, bennett@bme.jhu.edu
% History: MRM Final Project: 12/1/05

if(length(r)==1)
CubeCorners = [1 1 1; 1 -1 1;-1 -1 1; -1 1 1; 1 1 -1; 1 -1 -1;-1 -1 -1;-1 1 -1]*r;
else
    CubeCorners = [1 1 1; 1 -1 1;-1 -1 1; -1 1 1; 1 1 -1; 1 -1 -1;-1 -1 -1;-1 1 -1];
    CubeCorners = CubeCorners.*repmat(r,[8 1]);
end    
CubeEdges = [1 2;2 3;3 4;4 1;1 5;2 6;3 7;4 8;5 6;6 7;7 8;8 5];
sides = {[1 2 3 4],[1 2 6 5],[1 5 8 4],[2 3 7 6], [3 4 8 7], [5 6 7 8]};
nodeClr = [.5 1 .5];
h=[];
for j=1:length(sides)    
    vertices = CubeCorners(sides{j},:);
    h(j)= patch(vertices(:,1),vertices(:,2),vertices(:,3),clr,varargin{:});
end

