javaaddpath(genpath('C:\Program Files\MATLAB71_SV\work\MRM\bin\'))
addpath(genpath('C:\Program Files\MATLAB71_SV\work\MRM\'))
%createDiffusionModels
%modelFilename = 'C:\Program Files\MATLAB71_SV\work\MRM\Model_Jon.mat';
modelFilename = 'C:\Program Files\MATLAB71_SV\work\MRM\Model_UnconstrainedGaussian.mat';
load(modelFilename)

%shape = diffusionModel.Geometry.shape;
%patch(S,'facecolor','green','edgecolor','black','edgealpha',1,'facealpha',0.1) 
%axis([0 2 0 2 0 2])
%box on, axis square

showCompartment(diffusionModel)
numSpinPackets = 1000; %number of packets
diffusionTime = 70; %ms 
timeStep = 20; %us
shortPulse = 1;
MotionResults = SimulateBrownianMotion(modelFilename, diffusionModel,numSpinPackets,...
    diffusionTime,timeStep,shortPulse)
%MotionResults = SimulateBrownianMotionInside(modelFilename, diffusionModel,numSpinPackets,...
%    diffusionTime,timeStep,shortPulse)
motionInfo = MotionResults;
encodingDir = [0 0 1];
delta = 16; %ms
G = 60; %mT/m
G = G/100; % mT/cm
GradLobeArea = delta*G; %(mT/cm)*ms
T2 = 100000; %ms 
[adc,signal] = simulateADC(motionInfo,encodingDir,GradLobeArea,T2);

displacement = sqrt(sum(MotionResults.brownianMotion.^2,2));
rmsd = sqrt(mean(displacement.^2))


% diffusionTime = 70; %ms 
% delta = 16; %ms
% G = 60; %mT/m
% G = G/100; % mT/cm
% GradLobeArea = delta*G; %(mT/cm)*ms
% gamma = 267.52e6; % rad s-1 T-1
% gamma = gamma/(1000*1000); % rad ms-1 mT-1
% q = (gamma/(2*pi))*GradLobeArea/10 % 1/mm % GradLobeArea => mT/cm * ms
% qcm = (gamma/(2*pi))*GradLobeArea
% motion = 10; % um
% %signal = exp(i.*q*2*pi.*motion/1e3) % motion is in um, so put in mm
% signal = 0.16;
% adc = -1/(4*pi*pi*q^2*(diffusionTime*1000/1e6))*log(signal)
% signal_calc = exp(-4*pi*pi*q^2*diffusionTime*1000/1e6*adc)
% rmsd = sqrt(6*adc*diffusionTime*1000/1e6) % mm
% rmsd_microns = rmsd*1000


