function txt = showCompartment(diffusionModel)
% showCompartment -- show diffusion model in 3d (internal use)
%   txt = showCompartment(diffusionModel)
%       diffusionModel - a structure of the form generated by 
%              createDiffusionModels.m
%       txt - descriptive text
%
% Copyright (C) 2005 Bennett Landman, bennett@bme.jhu.edu
% History: MRM Final Project: 12/1/05

% Step 1. Prune the model to be inside the lattice because the simulator
% ignores regions outside of the lattice repeat (this enables infinite
% shapes). Use patch to show the shape when ready.
clf;
clr = jet(length(diffusionModel.Geometry));
for j=1:length(diffusionModel.Geometry)
    shape = local_prune(diffusionModel.Geometry(j).shape,diffusionModel.latticeDimensions);
    h=patch('faces',shape.faces,'vertices',shape.vertices,'edgealpha',.1,'edgecolor','black','facealpha',.4,'facecolor',clr(j,:));
end

% Step 2. Step a bounding cube to give perspective
axis equal off;
set(gcf,'color','white');
view(0,-75);

plot3DCube(diffusionModel.latticeDimensions,[1 1 0],'facealpha',.05);
axis on equal tight ;
grid on; 
xlabel('X (\mum)')
ylabel('Y (\mum)')
zlabel('Z (\mum)')
view(-38,-59)
title(diffusionModel.name);
txt = ''; % not used

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% shape = local_prune(shape,limits)
% Local function to hide facets that are completely outside
% the lattice unit
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function shape = local_prune(shape,limits)
keep = ones([length(shape.faces) 1]);
for j=1:length(keep)
    v = shape.vertices(shape.faces(j,:),:);
    for k=1:3
        if(3==sum(v(:,k)>=limits(k)))
            keep(j)=0;
        elseif(3==sum(v(:,k)<=0))
            keep(j)=0;
        end
    end
end
      
shape.faces = shape.faces(find(keep),:);