function showTensorVariability(handles)
% showTensorVariability -- repeat 10 tensor estimations with nosie and visualize eigenvectors (internal use)
%   showTensorVariability(handles)
%       handles - MRMproject GUI handles (used to exchange data)
%
% Copyright (C) 2005 Bennett Landman, bennett@bme.jhu.edu
% History: MRM Final Project: 12/1/05


% Step 1. Retrieve the data 
adc = get(handles.ADC,'UserData');
signal = get(handles.SIGNAL,'UserData');
grad = get(handles.diffusionWeightingFile,'userdata');
motionInfo = get(handles.motionReady,'UserData');
GradLobeArea = str2num(get(handles.gradientArea,'string'));
T2 = str2num(get(handles.T2,'string'));
T2decay = exp(-motionInfo.parameters.diffusionTime/1e3/T2);


% Step 2. Estimate 10 tensors with Gaussian noise added in quadrature
gamma = 2.675e2; % rad ms-1 mT-1
q = gamma*GradLobeArea/10; % mm % GradLobeArea => mT/cm * ms

for j=1:10
    snr = str2num(get(handles.PSNR,'String'));

    noiseLevel = 1/snr; % std of gaussian noise in quadrature

    adc0 = [];
    i=sqrt(-1);
    for jDir = 1:size(grad,1)        
        signal2 = T2decay*signal(jDir,:)+(randn(size(signal(jDir,:)))+i*randn(size(signal(jDir,:))))*noiseLevel;
        adc0(jDir) = -1/(q^2*(motionInfo.parameters.diffusionTime/1e6))*log(abs(mean(signal2)./T2decay)); %mm2/s
    end

    % Visualize the eigenvectors of each estimate
    Tensor = estimateTensor(grad,adc0);
    [v,e] = eigs(Tensor);
    es = sort([e(1,1) e(2,2) e(3,3)]);
    hold on
    for je=1:3
        [i,j] = find(e==es(je));
        h=quiver3(0,0,0,v(1,j)*es(je),v(2,j)*es(je),v(3,j)*es(je),'r');
        for k=1:length(h)
            set(h(k),'linewidth',2)
        end
        hold on;
    end
end


% Step 3. Overlay the eigenvectors of the original estimate
Tensor = estimateTensor(grad,adc);
[v,e] = eigs(Tensor);
es = sort([e(1,1) e(2,2) e(3,3)]);

hold on
for je=1:3
    [i,j] = find(e==es(je));
    h=quiver3(0,0,0,v(1,j)*es(je),v(2,j)*es(je),v(3,j)*es(je));
    for k=1:length(h)
        set(h(k),'linewidth',4)
    end
    hold on;
end
%plot3([x2 -x2],[y2 -y2],[z2 -z2],'.')
axis off;
set(gcf,'color','white');

% Step 4. Animate the results
busy
for i=0:180
    view(i,30);
    pause(.01);
end
idle