% Example script for creating optimial sets of points on sphere
% (C)opyright 2005, Bennett Landman, bennett@bme.jhu.edu
% Revision History:
% Created: 3/31/2005

clear Results;
Niter = 100;
Experiments = {
    % Format:
    % 'Name', # Pts, # Heirarchical Levels to Consider, # Level Wt, inf, inf;
    'Flat', 30, 1, 1, inf, inf;
    'Heir', 30, 2, 1, inf, inf;
    }

Results.x=[];
Results.y=[];
Results.z=[];

for je=1:Niter
    for je=1:size(Experiments,1)
        tic;
        % Create some variables for ease of use
        pts = Experiments{je,2};
        levels = Experiments{je,3};
        levwt = Experiments{je,4};
        bestAng = Experiments{je,5};
        bestE = Experiments{je,6};
        
        % Randomly place the right number of points on a hemisphere
        [x,y,z] = randPtsOnSphere(pts);
        x = abs(x);

        % Run the optimization procedure
        [x,y,z,E] = optSymPtsOnSphere_relax2(x,y,z,2500,.125,levels,levwt,@electricForceHeir);
        
        % Store this one as the best if it has the minimum energy        
        if(E<bestE)
            Results(je).x = x;
            Results(je).y = y;
            Results(je).z = z;
            Experiments{je,5} = minAnglePtsOnSphere([x -x],[y -y],[z -z])*180/pi;;
            Experiments{je,6} = E;
            beep
        end
        
        disp(sprintf('%.0d %.2f %.2f', je, bestE, E));
        Experiments{je,7} = toc;
        disp(Experiments);
    end
end

for j=1:size(Experiments,1)
    figure(j), plotPtsFig(Results(j).x,Results(j).y,Results(j).z,['"Jones":' Experiments{j,1} ' ' num2str(Experiments{j,2})]);
end


