function fillPolySph(N,x,y,z,C,varargin)
% function fillPolySph(N,x,y,z,C,varargin)
%
% Create a filled polygon with the edges between
% the sets of points replaced by great circles
% with N incremental points. The remainder of the arguments
% are identical to fill3.
%
% (C)opyright 2005, Bennett Landman, bennett@bme.jhu.edu
% Revision History:
% Created: 2/14/2005


myFillPolySph(N,x,y,z,C,varargin{1:end});

x(end+1)=x(1);
y(end+1)=y(1);
z(end+1)=z(1);
plotSphTri(N,x,y,z);
hold off;

function myFillPolySph(N,x,y,z,C,varargin)
if(length(x)==3)
    X = zeros([N N]);
    Y = zeros([N N]);
    Z = zeros([N N]);
    xx = midPtOnSphereCart([x(1) y(1) z(1)],[x(end),y(end),z(end)],linspace(0,1,N)');
    yy = midPtOnSphereCart([x(1) y(1) z(1)],[x(2),y(2),z(2)],linspace(.1,1,N)');
    for j=1:size(xx,1)
        zz = midPtOnSphereCart(xx(j,:),yy(j,:),linspace(0,1,N)');
        X(j,:) = zz(:,1)';
        Y(j,:) = zz(:,2)';
        Z(j,:) = zz(:,3)';
    end
    h = mesh(X,Y,Z); hold on;
    set(h,'EdgeColor','none');
    set(h,'FaceColor',C);
    for j=1:2:length(varargin{1})
        set(h,varargin{1},varargin{2});
    end
else


    x0 = [x(1) x(2) x(end)];
    y0 = [y(1) y(2) y(end)];
    z0 = [z(1) z(2) z(end)];
    myFillPolySph(N,x0,y0,z0,C,varargin{:});
    myFillPolySph(N,[ x(2:end)],[y(2:end)],[z(2:end)],C,varargin{:});
end
