function ang = maxAnglePtsOnSphere(x,y,z,r)
% function ang = maxAnglePtsOnSphere(x,y,z,r)
% 
% Find the maximum angle of the r-th smallest
% angle for each point. 
%
% (C)opyright 2005, Bennett Landman, bennett@bme.jhu.edu
% Revision History:
% Created: 2/11/2005
ang = -inf;
pts = length(x);
for j=1:(pts)
    ang0 = zeros([1 pts]);
    for k=1:(pts)
        ang0(k) = real(acos(sum([x(j) y(j) z(j)].*[x(k) y(k) z(k)])));        
    end
    ang0 =sort(ang0);
    ang = max(ang,ang0(r));
end