function [PHI, TH] = midPtOnSphere(PHI1, TH1, PHI2, TH2, f)
% function [PHI, TH] = midPtOnSphere(PHI1, TH1, PHI2, TH2, f)
%
% Find the point on a great circle that is f*100% between (Ph1,Th1) and
% (Ph2, Th2). 
%
% (C)opyright 2005, Bennett Landman, bennett@bme.jhu.edu
% Revision History:
% Created: 2/11/2005
d=2*asin(sqrt((sin((PHI1-PHI2)/2)).^2 + cos(PHI1).*cos(PHI2).*(sin((TH1-TH2)/2)).^2));
if(d>0)
A=sin((1-f)*d)./sin(d);
B=sin(f*d)./sin(d);
x = A.*cos(PHI1).*cos(TH1) +  B.*cos(PHI2).*cos(TH2);
y = A.*cos(PHI1).*sin(TH1) +  B.*cos(PHI2).*sin(TH2);
z = A.*sin(PHI1)           +  B.*sin(PHI2);
PHI=atan2(z,sqrt(x.^2+y.^2));
TH=atan2(y,x);
else
    PHI=PHI1;
    TH=TH1;
end