function [x,y,z,E] = optSymPtsOnSphere_relax2(x,y,z,iters,stepsize,levels,levelwt, forceMetric)
% function [x,y,z,E] = optSymPtsOnSphere_relax2(x,y,z,iters,stepsize,levels,levelwt, forceMetric)
%
% Relaxation optimization for points on a sphere.
% Optimzies the initial placement of points (x,y,z) on a sphere for iters
% iterations with a relative step size of stepsize. We reccomend a step
% size (0, 1]. Levels and levelwt are arguments to the forceMetric function
% argument. This parameter is charged with computing the gradient field as
% well as the potential energy field. See electricForceHeir.m
%
% The function returns the optimized set of points as well as the estimated 
% potential energy of the arragement. 
%
% (C)opyright 2005, Bennett Landman, bennett@bme.jhu.edu
% Revision History:
% Created: 2/11/2005

pts = length(x);

[F,E] = forceMetric(x,y,z,levels,levelwt);


firstx = x;
firsty=y;
firstz=z;
firstE = E;


lastE = E;
for iter=1:iters
    [F,E] = forceMetric(x,y,z,levels,levelwt);
    
    
    if(E>lastE)
        stepsize=stepsize/2;
    end
    lastE=E;
  scale = max(max(abs(F(:)/stepsize)),1);
    
    x = x+F(:,1)'/scale;
    y = y+F(:,2)'/scale;
    z = z+F(:,3)'/scale;
    [theta, phi, r] = cart2sph(x,y,z);
    [x,y,z] = sph2cart(theta,phi,ones([1 pts]));   
    
    
end

[F,E] = forceMetric(x,y,z,levels,levelwt);

if(E>firstE)
    E=firstE;
    x=firstx;
    y=firsty;
    z=firstz;
end