function [X0,SLOPE] = planeIntersect(ABCD1,ABCD2)
% function [X0,SLOPE] = planeIntersect(ABCD1,ABCD2)
%
% Find the line that lies at the intersection of two planes.
%
% (C)opyright 2005, Bennett Landman, bennett@bme.jhu.edu
% Revision History:
% Created: 2/11/2005

N1 = ABCD1(1:3);
d1 = ABCD1(4);
N2 = ABCD2(1:3);
d2 = ABCD2(4);

determinant = dot( N1 , N1 )*dot( N2 , N2 ) - dot( N1 , N2 ).^2 ;
c1 = ( d1*dot( N2, N2) - d2*dot( N1 , N2 )) / determinant;
c2 = ( d2*dot(N1, N1) - d1 *dot(N1 , N2)) / determinant ;

X0 =c1*N1 + c2*N2;
SLOPE = cross(N1,N2);
