function plotPtsFig(x,y,z,STR,nodouble)
% function plotPtsFig(x,y,z,STR,nodouble)
%
% Plot the points (x,y,z) and (-x,-y,-z) on a unit sphere
% using levels number of heirarchical levels. If nodouble is non-zero, 
% only (x,y,z) are included. Label the figure with "STR". Also included
% in this visualization are various properties of the resulting DTI
% gradient matrix. 
%
% (C)opyright 2005, Bennett Landman, bennett@bme.jhu.edu
% Revision History:
% Created: 4/6/2005
% Bug Fix: 6/15/2005 - Compatibility with Matlab 6.5.

R = epsunique(10,sqrt(x.^2+y.^2+z.^2));
if(length(epsunique(10,[1 R]))>1)
    %warning('Points do not lie on the surface of a unit sphere within working precision.');
    [X] = forceToSphere([x(:) y(:) z(:)]);
    x = X(:,1)';
    y = X(:,2)';
    z = X(:,3)';
end

if(~exist('nodouble'))
    nodouble=0;
end
if(nodouble)
    X = x(:)'; Y = y(:)'; Z = z(:)';
else
X = [x(:)' -x(:)']; Y = [y(:)' -y(:)']; Z = [z(:)' -z(:)'];
end
TRI = delaunaySphere(X,Y,Z);
VORPOLY = voronoiSphere(X,Y,Z,TRI);
    VArea = [];
     
    for j=1:length(VORPOLY)
        Xpt =  [X(j) Y(j) Z(j)];
        Vpts = VORPOLY{j};
        VArea(j) = sphPolyArea(Xpt,Vpts);
    end
    
aa = [0 0 -90];
bb = [90 180 180];
for jj=1:3
    subplot(2,2,jj);
    plotVoronoi(X,Y,Z,VORPOLY,1); title(STR);
    axis on
    xlabel('x')
    ylabel('y')
    zlabel('z')
    view(aa(jj),bb(jj));

end

mySubPlot(2,2,2,1,4,1);
A = ([x.^2; x.*y*2; x.*z*2; y.^2; y.*z*2; z.^2]');

h=title({sprintf('Potential: %.1f',elecPotentialXYZ(x,y,z,nodouble)),...
    sprintf('Minimum Angle: %.2f',minAnglePtsOnSphere(X,Y,Z)*180/pi),...
    sprintf('Std. Dev. of Voronoi Areas: %.2e',std(VArea)),...
    sprintf('Condition #: %.2f',cond(A)), date});
set(h,'VerticalAlignment','top');
axis off;

mySubPlot(2,2,2,1,4,2);
hist(VArea,length(VArea));
xlabel('Voronoi Area');
ylabel('#')
