function [verybestSet,verybestErr] = selectOptSubset(x,y,z,N,iters,seed)

if(~exist('iters'))
    iters=1000;
end
if(~exist('seed'))
verybestSet = randSet(length(x),N);;
else
    if(length(seed)==0)
        verybestSet = randSet(length(x),N);;
    else
    verybestSet = seed;
    end
end
X = [x -x];
Y = [y -y];
Z = [z -z];

R = zeros([length(X) length(X)]);
for j=1:length(X)
    for k=1:length(X)
        if(j==k)
            R(j,k) = 0;

        else
            R(j,k) = 1./sqrt(sum(([X(j) Y(j) Z(j)]-[X(k) Y(k) Z(k)]).^2));
        end
    end
end



verybestErr = [verybestSet  ; verybestSet  ]'*R*[verybestSet  ; verybestSet  ];

bestSet=verybestSet;
bestErr=verybestErr;

for j=1:iters
    change = 0;
    for k=1:N
        for m=1:N
            if(bestSet(k)~=bestSet(m))
                myset=bestSet;
                myset(k) = myset(m);
                myset(m)= bestSet(k);
                err = 0;
                for q=1:max(myset)
                    err = err+[myset==q; myset==q]'*R*[myset==q; myset==q];
                end
                if(err<bestErr)
                    bestErr = err;
                    bestSet = myset;
                    change = 1;
                    break;
                end
            end
        end
    end
    if(~change)
        if(bestErr<verybestErr)
            verybestErr=bestErr;
            verybestSet = bestSet;
        end
        bestSet = randSet(length(x),N);
        bestErr = [bestSet ; bestSet ]'*R*[bestSet ; bestSet ];
    end

end
%disp(verybestErr)

function set = randSet(n,N)
set = zeros([n 1]);
for j=1:length(N)
    f = find(set==0);
    x = rand([length(f) 1]);
    b = sort(x);
    set(f(find((x<=b(N(j))))))=j;
end