function viewSphereResults(x,y,z,levels)
% function viewSphereResults(x,y,z,levels)
%
% View results of heirachical optimization of placemnet of 
% points on a sphere. 
%
% (C)opyright 2005, Bennett Landman, bennett@bme.jhu.edu
% Revision History:
% Created: 2/11/2005
figure, 
subplot(2,2,1);

myLabel = {...
    sprintf('%d Points',length(x)),...
    sprintf('%d Levels', levels),...
    sprintf('%.2f Minimum Angular Separation', 180/pi*minAnglePtsOnSphere(x,y,z)),...
    };


pts = length(x);
    for j=levels:-1:1
        inc = 1:(pts/2^(levels-j));
        off = min(inc)-1;
        out = ['Opt Energy (Level ' num2str(levels-j+1) '):'];
        k=1;
        while(off<pts)
            [F, E] = staticForceH(x(off+inc),y(off+inc),z(off+inc),1,1);
            ang = 180/pi*minAnglePtsOnSphere(x(off+inc),y(off+inc),z(off+inc));
            
            if k==3
                myLabel{end+1} = out;
                out=['                              '];
            end
            k=k+1;
            out = [out sprintf(' %.0f (%.2f)',E,ang)];
            
            off = off+max(inc);
        end
        myLabel{end+1} = out;
    end
    


h=text(0,.5,myLabel);
axis off;

subplot(2,2,2);
plotSymPtsOnSphere(x,y,z,levels)
subplot(2,2,3);
plotSymPtsOnSphere(x,y,z,levels)
view(0,0);
subplot(2,2,4);
plotSymPtsOnSphere(x,y,z,levels)
view(0,90)