package bl.diffusion;

import java.util.Iterator;
import java.util.Vector;
import java.util.Map;

/**
 * Created by IntelliJ IDEA.
 * User: bennett
 * Date: Nov 23, 2005
 * Time: 4:42:42 PM
 * To change this template use Options | File Templates.
 * ************************************
 * Magnetic Resonance in Medicine Final Project
 * Released: December 1, 2005
 *
 * class CompartmentIterator
 *      Implements an iterator so that only compartments that could possiblely
 *  contain a point are returned in the detection process.
 *
 * Copyright (C) 2005 Bennett Landman, bennett@bme.jhu.edu
 */

public class CompartmentIterator implements Iterator {
    // Stores how many compartments have been returned
    private int idx;
    // Used as a flag to determine if we are returning all compartments or just possible ones
    private SimCompartment myLocalEnv;
    // A list of all compartments
    private Vector myCompartments;
    // A list of compartments in the local neighborhood
    Vector myNeigborhood;

    // Create a new iterator
    public CompartmentIterator(Vector compartments, SimCompartment localEnv, Map insideMap) {
        idx=0;
        myLocalEnv = localEnv;
        myCompartments = compartments;
        if(localEnv!=null && insideMap.containsKey(localEnv)) {
            myNeigborhood = (Vector)insideMap.get(localEnv);
        } else {
            myNeigborhood = new Vector();
        }
    }

    // Check to see if more compartments are waiting
    public boolean hasNext() {
        if(myLocalEnv==null) {
            return idx<myCompartments.size();
        } else {
            return idx<(1+myNeigborhood.size());
        }
    }

    // Return the next compartment
    public Object next() {
        if(!hasNext())
            return null;
        Object obj = null;
        if(myLocalEnv==null) {
            obj = myCompartments.get(idx);
            idx++;
        } else {
            //we only deal with inside/outside
            if(idx<myNeigborhood.size())
                obj = myNeigborhood.get(idx);
            else
                obj= myLocalEnv;
            idx++;
        }
        return obj;
    }

    // We do not support this method
    public void remove() {
        throw new UnsupportedOperationException();
    }


}
