package bl.diffusion;

import Jama.Matrix;

/**
 * Created by IntelliJ IDEA.
 * User: bennett
 * Date: Nov 20, 2005
 * Time: 9:21:15 AM
 * To change this template use Options | File Templates.
 * ************************************
 * Magnetic Resonance in Medicine Final Project
 * Released: December 1, 2005
 *
 * class PT
 *      Represent a 3-tuple. For use as a point, vector, etc.
 *
 * Copyright (C) 2005 Bennett Landman, bennett@bme.jhu.edu
 */
public class PT {
    public double x,y,z; // coordinates

//  create a new PT
    public PT(PT pt) {
        x=pt.x;y=pt.y;z=pt.z;
    }
 

    // create a new PT
    public PT(double x0,double y0,double z0) {
        x=(double)x0;y=(double)y0;z=(double)z0;
    }
//  create a new PT
    public PT(double []pt) {
        x=pt[0];y=pt[1];z=pt[2];
    }
    // convert position to an Matlab coordinate index
    long cor2ind(int sx,int  sy) {
        return Math.round(x)+sx*(Math.round(y)+Math.round(z)*sy);
    }

    // convert coordinate to a string for debugging
    public String toString() {
        return "["+(x)+","+(y)+","+(z)+"]";
    }

    // perform coordinate-wise equality test
    public boolean equals(PT pt) {
        return (pt.x==x)&&(pt.y==y)&&(pt.z==z);
    }

    // perform coordinate-wise subtraction
    public PT minus(PT b) {
        return new PT(x-b.x,y-b.y,z-b.z);
    }

    // perform coordinate-wise addition
    public PT plus(PT b) {
        return new PT(x+b.x,y+b.y,z+b.z);
    }

    // perform the vector cross-product
    public PT cross(PT b) {
        return new PT(
          y*b.z-z*b.y, z*b.x-x*b.z,x*b.y-y*b.x
        );
    }

    // multiply by a scalar
    public PT times(double t) {
        return new PT(x*t,y*t,z*t);
    }
    
    public PT times(Matrix m) {
    	double [][]foo = new double[4][1];
    	foo[0][0] = x;
    	foo[1][0] = y;
    	foo[2][0] = z;
    	foo[3][0] = 1;
    	Matrix result = m.times(new Matrix(foo));
    	return new PT(result.get(0,0),result.get(1,0),result.get(2,0));
    }

    // perform the vector dot product
    public double dot(PT b) {
        return x*b.x+y*b.y+z*b.z;
    }

    // compute the L-2 norm of the vector
    public double length() {
        return Math.sqrt(x*x+y*y+z*z);
    }

	public double norm() {
		// TODO Auto-generated method stub
		return length();		
	}
	   // compute the squared L-2 norm of the vector
    public double norm2() {
        return (x*x+y*y+z*z);
    }
    
    public PT normalize() {
    	double n = norm();
    	return this.times((double)(1./n));
    }
}
