package bl.diffusion;

import java.util.Vector;

/**
 * Created by IntelliJ IDEA.
 * User: bennett
 * Date: Nov 20, 2005
 * Time: 9:43:48 AM
 * To change this template use Options | File Templates.
 * ************************************
 * Magnetic Resonance in Medicine Final Project
 * Released: December 1, 2005
 *
 * class Polyhedron
 *      Represent a triangulated 3D polyhedron.
 *
 * Copyright (C) 2005 Bennett Landman, bennett@bme.jhu.edu
 */
public class Polyhedron {
    // An array of faces
    Triangle faces[];
    // Bounding box for all points in this polyhedron
    BndBox boundingBox;

    // Create a new Polyhedron from a Vector of Triangles
    public Polyhedron(Vector in) {
        faces = new Triangle[in.size()];
        boundingBox = new BndBox();
        for(int i=0;i<in.size();i++) {
            faces[i] = (Triangle)in.get(i);
            boundingBox.union(faces[i]);
        }
    }

    // Create a new Polyhedron from a list of vertices and faces.
    // Note: faces are zero-indexed into the vertex array
    public Polyhedron(double [][]vertData, double [][]faceData) {
        PT []verts = new PT[vertData.length];
        for(int i=0;i<verts.length;i++) {
            verts[i] = new PT(vertData[i][0],vertData[i][1],vertData[i][2]);
        }
        faces = new Triangle[faceData.length];
        for(int i=0;i<faces.length;i++) {
            faces[i] = new Triangle(verts[(int)faceData[i][0]],verts[(int)faceData[i][1]],
                                    verts[(int)faceData[i][2]]);
        }
        boundingBox = new BndBox();
        for(int i=0;i<faces.length;i++) {
            boundingBox.union(faces[i]);
        }
    }


    // detect if this polyhedron contains a particular point
    public boolean contains(PT p) {
        // Algorithm: select a random direction. Count the number of faces that the a ray from the point crosses
        // a face. If it is odd, then p is interior, if it is even, then p is exterior. If the ray hits an edge or a
        // vertex, select a new random vector
        while(true) {
            try {
                PT p2 = new PT(p.x+(double)(Math.random()-.5)*10000,p.y+(double)(Math.random()-.5)*10000,p.z+(double)(Math.random()-.5)*10000);
                int crossings = 0;
                for(int i=0;i<faces.length;i++) {
                    try {
                        IntersectResult s = faces[i].findIntersect(p,p2);
                        if(s.fractionalDistance>0)
                            crossings++;
                        if(s.fractionalDistance==0)
                            return true; // On an edge or vertex
                    } catch (Exception e) {};

                }
                return (crossings%2)==1;
            } catch (Exception e) {
                // We are expecting a DegenerateIntersectionException. We need to choose a new random ray.
            }
        }
    }


    // This is a test function to create a unit cube
    static Polyhedron unitCube() {
        Vector v = new Vector();
        PT PT000 = new PT(0,0,0);
        PT PT001 = new PT(0,0,1);
        PT PT010 = new PT(0,1,0);
        PT PT011 = new PT(0,1,1);
        PT PT100 = new PT(1,0,0);
        PT PT101 = new PT(1,0,1);
        PT PT110 = new PT(1,1,0);
        PT PT111 = new PT(1,1,1);
        //left
        v.add(new Triangle(PT000,PT001,PT010));
        v.add(new Triangle(PT011,PT001,PT010));
        //right
        v.add(new Triangle(PT100,PT101,PT110));
        v.add(new Triangle(PT111,PT101,PT110));
        //down
        v.add(new Triangle(PT000,PT001,PT100));
        v.add(new Triangle(PT101,PT001,PT100));
        //up
        v.add(new Triangle(PT010,PT011,PT110));
        v.add(new Triangle(PT111,PT011,PT110));
        //out
        v.add(new Triangle(PT000,PT010,PT100));
        v.add(new Triangle(PT110,PT010,PT100));
        //in
        v.add(new Triangle(PT001,PT011,PT101));
        v.add(new Triangle(PT111,PT011,PT101));
        return new Polyhedron(v);
        //return new Polyhedron(v);
    }

    // Find the location of the first intersection
    public IntersectResult firstIntersection(PT a, PT b) {
//        if((!boundingBox.inside(a)) && (!boundingBox.inside(b))) {
//            // assume that we will not jump across rois
//        	System.out.println(getClass().getCanonicalName()+"\t"+"bb");
//            return null;
//        }
        IntersectResult firstHit = null;
        double firstDist = Double.MAX_VALUE;
        for(int i=0;i<faces.length;i++){
            try {
                IntersectResult hit = faces[i].findIntersect(a,b);
                if(hit!=null) {
                    if(hit.fractionalDistance<firstDist && hit.fractionalDistance>0) {
                        firstDist = hit.fractionalDistance;
                        firstHit = hit;
                    }
                }
            } catch (DegenerateIntersectionException e) {
          //      if(RandomWalkSimulator.intenseDebug)
                    //System.out.println(getClass().getCanonicalName()+"\t"+e);
            }
        }
        return firstHit;
    }
}
