package bl.diffusion;

import java.awt.*;

/**
 * Source: http://www.javaworld.com/javaworld/jw-12-1996/progressbar/ExampleWithProgressBar.html
 * * ************************************
 * Magnetic Resonance in Medicine Final Project
 * Released: December 1, 2005
 */

public class ProgressBar extends Frame
{
    private              int Count;
    private              int Max;
    private static final int FrameBottom = 24;
    public boolean open = true;

    public ProgressBar (String Title, int TotalItems)
    {
        super(Title);

        Count = 0;
        Max   = TotalItems;

        // Allowing this to be resized causes more trouble than it is worth
        // and the goal is for this to load and launch quickly!
        setResizable(false);

        setLayout(null);
        addNotify();
        resize (insets().left + insets().right + 379,
                insets().top + insets().bottom + FrameBottom);
        open = true;
    }

    public synchronized void show()
    {
        move(50, 50);
        super.show();
    }

    // Update the count and then update the progress indicator.  If we have
    // updated the progress indicator once for each item, dispose of the
    // progress indicator.
    public void updateProgress ()
    {
        ++Count;

        if (Count == Max)
            dispose();
        else
            repaint();
    }


    // Paint the progress indicator.
    public void paint (Graphics g)
    {
        Dimension FrameDimension  = size();
        double    PercentComplete = (double)Count * 100.0 /(double)Max;
        int       BarPixelWidth   = (FrameDimension.width * Count)/ Max;

        // Fill the bar the appropriate percent full.
        g.setColor (Color.red);
        g.fillRect (0, 0, BarPixelWidth, FrameDimension.height);

        // Build a string showing the % completed as a numeric value.
        String s        = String.valueOf((int)PercentComplete) + " %";

        // Set the color of the text.  If we don'fractionalDistance, it appears in the same color
        // as the rectangle making the text effectively invisible.
        g.setColor (Color.black);

        // Calculate the width of the string in pixels.  We use this to center
        // the string in the progress bar window.
        FontMetrics fm       = g.getFontMetrics(g.getFont());
        int StringPixelWidth = fm.stringWidth(s);

        g.drawString(s, (FrameDimension.width - StringPixelWidth)/2, FrameBottom-10);
    }

    public boolean handleEvent(Event event)
    {
        if (event.id == Event.WINDOW_DESTROY)
        {
            dispose();
            System.out.println(getClass().getCanonicalName()+"\t"+"Progress Bar Manually Closed.");
            open = false;
            return true;
        }

        return super.handleEvent(event);
    }
}
