package bl.diffusion;

import java.util.Iterator;
import java.util.Vector;

public class SimCompartmentDifference implements SimCompartment {

	private SimCompartment myContains;
	private Vector myButNotIn;
	// the diffusion coefficient in the compartment
	private double diffusionCoefficient;

	// The probability of crossing the membrane - us/um
	private double membranePermeability;

	private static double EPS = 1e-5f;
	private double T2; 
	public double getT2() {return T2;};

	public SimCompartmentDifference(double membranePermeability,
			double diffusionCoefficient, double T2, SimCompartment baseCompartment) {
		this.T2=T2;
		myContains = baseCompartment;
		myButNotIn = new Vector();

//		if(transmissionProbability<0 || transmissionProbability>1)
//			throw new RuntimeException("Invalid transmissionProbability");
		this.membranePermeability = membranePermeability;
		if(diffusionCoefficient<=0)
			throw new RuntimeException("Invalid diffusionCoefficient");
		this.diffusionCoefficient = diffusionCoefficient;
	}

	public void removeCompartment(SimCompartment compartment) {
		myButNotIn.add(compartment);
	}

	public boolean contains(PT p) {
		if(!myContains.contains(p))
			return false;
		if(myButNotIn.size()<1)
			return true;
		Iterator i = myButNotIn.iterator();
		while(i.hasNext()) {
			SimCompartment next = (SimCompartment)i.next();
			if(next.contains(p))
				return false;
		}		
		return true;
	}

	private IntersectResult findAnyFirstIntersection(PT a, PT b) {
		IntersectResult currentResult = myContains.findFirstIntersection(a, b);
		Iterator i = myButNotIn.iterator();
		while(i.hasNext()) {
			SimCompartment next = (SimCompartment)i.next();
			IntersectResult thisResult = next.findFirstIntersection(a, b);
			if(thisResult!=null) {
				if(currentResult==null)
					currentResult=thisResult;
				else if(currentResult.fractionalDistance >= 0 && 
						thisResult.fractionalDistance >= 0 && 
						currentResult.fractionalDistance > thisResult.fractionalDistance)
					currentResult = thisResult;
			}
		}	
		return currentResult;
	}

	public IntersectResult findFirstIntersection(PT a, PT b) {
		IntersectResult currentResult = findAnyFirstIntersection(a, b);
		if(currentResult==null) 
			return null; 
		if(currentResult.fractionalDistance >1)
			return null;
		PT unitStep = b.minus(a).normalize();
		PT nextA = currentResult.intersectionPoint.plus(unitStep.times(EPS));
		boolean CnextA =contains(nextA);
		boolean CthisA = contains(a);
		if((CnextA == CthisA)) {
			// 	The found intersection is actually an interior/exterior point.
			IntersectResult next =findFirstIntersection(nextA, b);
			if(next==null)
				return next;
			next.fractionalDistance = (double)(currentResult.fractionalDistance+
					next.fractionalDistance*b.minus(nextA).norm()/b.minus(a).norm());
			if(next.fractionalDistance>1)
				return null;
			else 
				return next;
		} else { 
			return currentResult; 
		}
	}

	// return the membrane transmission probability
	public double getMembranePermeability() {
		return membranePermeability;
	}

	// return the compartment diffusion coefficient
	public double getDiffusionCoefficient() {
		return diffusionCoefficient;
	}

}
