package bl.diffusion;

/**
 * Created by IntelliJ IDEA.
 * User: bennett
 * Date: Nov 20, 2005
 * Time: 9:49:11 AM
 * To change this template use Options | File Templates.
 * ************************************
 * Magnetic Resonance in Medicine Final Project
 * Released: December 1, 2005
 *
 * class SimCompartment
 *      Represent a bounded diffusion compartment/region
 *
 * Copyright (C) 2005 Bennett Landman, bennett@bme.jhu.edu
 */
public class SimCompartmentPoly implements SimCompartment {
    // the diffusion coefficient in the compartment
    private double diffusionCoefficient;
    // the external bounding polyhedron of the compartment
    private Polyhedron poly;
    // The probability of crossing the membrane - us/um
    private double membranePermeability; 
    private double T2; 
	public double getT2() {return T2;};

    // Create a new simulation compartment
    public SimCompartmentPoly(Polyhedron boundingShape, double membranePermeability,
                          double diffusionCoefficient, double T2) {
    	this.T2=T2;
        poly = boundingShape;
//         if(transmissionProbability<0 || transmissionProbability>1)
//            throw new RuntimeException("Invalid transmissionProbability");
        this.membranePermeability = membranePermeability;
        if(diffusionCoefficient<=0)
            throw new RuntimeException("Invalid diffusionCoefficient");
          this.diffusionCoefficient = diffusionCoefficient;
    }

    // detect to see if the compartment contains a point
    public boolean contains(PT p) {
        return poly.contains(p);
    }

    // find the first intersection with the segment from a to b
    public IntersectResult findFirstIntersection(PT a, PT b) {
        return poly.firstIntersection(a,b);        
    }

    // return the membrane transmission probability
    public double getMembranePermeability() {
        return membranePermeability;
    }

    // return the compartment diffusion coefficient
    public double getDiffusionCoefficient() {
        return diffusionCoefficient;
    }
}
