package bl.diffusion;

public class SimCompartmentSphere implements SimCompartment {

	private PT myCenter = null;
	private double myRadius = 0;
	// the diffusion coefficient in the compartment
	private double diffusionCoefficient;

	// The probability of crossing the membrane - us/um
	private double membranePermeability;

	private double T2; 
	public double getT2() {return T2;};


	public SimCompartmentSphere(PT center, double radius, double membranePermeability,
			double diffusionCoefficient, double T2) {
		this.T2=T2;
		myCenter = new PT(center);
		if(radius<0)
			throw new RuntimeException("Invalid radius");
		myRadius = radius;
//		if(transmissionProbability<0 || transmissionProbability>1)
//			throw new RuntimeException("Invalid transmissionProbability");
		this.membranePermeability = membranePermeability;
		if(diffusionCoefficient<=0)
			throw new RuntimeException("Invalid diffusionCoefficient");
		this.diffusionCoefficient = diffusionCoefficient;
	}

	public boolean contains(PT p) {
		// TODO Auto-generated method stub
		if((p.minus(myCenter)).norm()<myRadius) 
			return true;
		else 
			return false;
	}


	public IntersectResult findFirstIntersection(PT a, PT b) {
		PT unitStep = b.minus(a);
		PT normUnitStep = unitStep.normalize();
		// Derived from http://local.wasp.uwa.edu.au/~pbourke/geometry/sphereline/
		double A = (b.minus(a)).norm2();
		double B = 2.*((b.x-a.x)*(a.x-myCenter.x)+
				(b.y-a.y)*(a.y-myCenter.y)+
				(b.z-a.z)*(a.z-myCenter.z));
		double C = myCenter.norm2()+a.norm2()-
		2.*(myCenter.x*a.x+myCenter.y*a.y+myCenter.z*a.z)-
		myRadius*myRadius;
		
		if(A==0)
			return null; 

		double det  = B*B-4*A*C;
		if(det<0) 
			return null; // no intersection
		if(det==0) {
			// exactly 1 intersection
			double u = -B/2/A;
			if(u<=0 || u > 1)
				return null; // no intersection

			PT p = a.plus((b.minus(a).times((double)u)));

			PT surfaceNormal=null;
			if(contains(a))
				surfaceNormal = myCenter.minus(p);
			else 
				surfaceNormal = p.minus(myCenter);
			surfaceNormal=surfaceNormal.times((double)(1./surfaceNormal.norm()));
			PT intersect = p;		
			PT eps = normUnitStep.times(IntersectResult.EPSILON);
			PT fwd = intersect.plus(eps);
			PT bck = intersect.minus(eps);
			if(contains(fwd)==contains(bck))
				return null;	//feature too small
			else
				return new IntersectResult(intersect,u,surfaceNormal,fwd,bck);
						
		}
//		exactly 2 intersections
		det = Math.sqrt(det);
		double u1 = (-B+det)/2/A;
		double u2 = (-B-det)/2/A;
		double u = 0;
		if(u2>0 && u2<=1)
			u=u2; //ray hits u2 first
		else if (u1>0 && u1<=1)
			u=u1; //ray hits u1 first
		else
			return null;  // no intersections are between a and b
			
		PT p = a.plus((b.minus(a).times((double)u)));

		PT surfaceNormal=null;
		if(contains(a))
			surfaceNormal = myCenter.minus(p);
		else 
			surfaceNormal = p.minus(myCenter);
		surfaceNormal=surfaceNormal.times((double)(1./surfaceNormal.norm()));
		PT intersect = p;		
		PT eps = normUnitStep.times(IntersectResult.EPSILON);
		PT fwd = intersect.plus(eps);
		PT bck = intersect.minus(eps);
		if(contains(fwd)==contains(bck))
			return null;	//feature too small
		else
			return new IntersectResult(intersect,u,surfaceNormal,fwd,bck);	
		
	}

	// return the membrane transmission probability
	public double getMembranePermeability() {
		return membranePermeability;
	}

	// return the compartment diffusion coefficient
	public double getDiffusionCoefficient() {
		return diffusionCoefficient;
	}

}
