package bl.diffusion;

public class test {
	static public void main(String args[]) {
		test1();
//		test2();
	}
	static public void test2() {
		System.out.println("\t"+"Test case 2");
		float extraCompartmentDiffusivity=2e-3f;
		float intraCompartmentDiffusivity=2e-3f;
		float membranePermeability=0;
		int NSteps = 1;// //% number of diffusion time steps
		float timeStepUS = 1; ////%us 20us timestep,D = 2e-3,root(6DtimeStep) = 0.5um, step.
		float diffusionTimeUS = 10000;
		float T2 = 100;
		float gamma = 267.52e6f; ////% rad s-1 T-1
		gamma = gamma/(1000*1000); ////% rad ms-1 mT-1
		float []latticeDimensions = {10, 10, 20};
		float []center = {10/2, 10/2, 20/2};
		float delta = 3; //%ms
		float cyl_rad = 1.5f;
		float sph_rad = 4f;
	    float cylinderLength = latticeDimensions[2]*.5f;
	    int numSpinPackets = 1000;
	    
		RandomWalkSimulator javaSimulator = new RandomWalkSimulator();
		javaSimulator.setLatticeInfo(extraCompartmentDiffusivity, //... //%UM2pUS
			    latticeDimensions[0],//...%um
			    latticeDimensions[1],//... %um
			    latticeDimensions[2],//... %um
			    T2); //%us
			    
		
		SimCompartmentCylinder javaObjectA = new SimCompartmentCylinder(new PT(center[0],center[1],center[2]), 
				cyl_rad, cylinderLength, membranePermeability,intraCompartmentDiffusivity,T2);
	
//		
		SimCompartmentSphere javaObjectB = new SimCompartmentSphere(new PT(center[0],center[1],center[2]), 
				sph_rad,  membranePermeability,intraCompartmentDiffusivity,T2);
		
		SimCompartmentUnion javaObjectC = new SimCompartmentUnion(membranePermeability,intraCompartmentDiffusivity,T2);
//		javaObjectC.addCompartment(javaObjectA);
//		javaObjectC.addCompartment(javaObjectB);
//		javaSimulator.createCompartment(javaObjectC);

//		javaSimulator.createCompartment(javaObjectA);
//		javaSimulator.createCompartment(javaObjectB);
		javaSimulator.createCompartment(javaObjectC);
		javaSimulator.setNumberSpins(numSpinPackets);
		javaSimulator.initializeRandomSpins();
//		javaSimulator.initializeRandomSpinsInside();
		javaSimulator.setSimTime(timeStepUS,diffusionTimeUS);
		javaSimulator.takeAWalk();
		

	}
	
	static public void test1() {
		System.out.println("\t"+"Test case 1");
		float extraCompartmentDiffusivity=2e-3f;
		float intraCompartmentDiffusivity=2e-3f;
		float transmissionProbability=0;
		int NSteps = 1;// //% number of diffusion time steps
		float timeStepUS = 1; ////%us 20us timestep,D = 2e-3,root(6DtimeStep) = 0.5um, step.
		float diffusionTimeUS = 20000;
		float T2 = 100;
		float gamma = 267.52e6f; ////% rad s-1 T-1
		gamma = gamma/(1000*1000); ////% rad ms-1 mT-1
		float []latticeDimensions = {10, 10, 20};
		float []center = {10/2, 10/2, 20/2};
		float delta = 3; //%ms
		float cyl_rad = 1.5f;
	    float cylinderLength = latticeDimensions[2]*.75f;
	    int numSpinPackets = 2000;
	    
		RandomWalkSimulator javaSimulator = new RandomWalkSimulator();
		javaSimulator.setLatticeInfo(extraCompartmentDiffusivity, //... //%UM2pUS
			    latticeDimensions[0],//...%um
			    latticeDimensions[1],//... %um
			    latticeDimensions[2],//... %um
			    T2); //%us
			    
		
		SimCompartmentCylinder javaObjectA = new SimCompartmentCylinder(new PT(center[0],center[1],center[2]-latticeDimensions[2]/2), 
				cyl_rad, cylinderLength, transmissionProbability,intraCompartmentDiffusivity,T2);
	
		
//		SimCompartmentCylinder javaObjectB = new SimCompartmentCylinder(new PT(center[0],center[1],center[2]+latticeDimensions[2]/2), 
//				cyl_rad, cylinderLength, transmissionProbability,intraCompartmentDiffusivity,T2);
		
//		SimCompartmentUnion javaObjectC = new SimCompartmentUnion(transmissionProbability,intraCompartmentDiffusivity,T2);
//		javaObjectC.addCompartment(javaObjectA);
//		javaObjectC.addCompartment(javaObjectB);
		javaSimulator.createCompartment(javaObjectA);

		javaSimulator.setNumberSpins(numSpinPackets);
		javaSimulator.initializeRandomSpins();
		
		javaSimulator.setSimTime(timeStepUS,diffusionTimeUS);
		javaSimulator.takeAWalk();
		

	}
}
/*

//% parameters for diffusion weighting experiment
encodingDir = [1 0 0; 0 1 0; 0 0 1];

G = [0:10:1200]; //%mT/m (1200mT/m = 120G/cm)


diffusionTimeMS = linspace(0,MaxDiffusionTimeMS,NSteps+1); //%ms
diffusionTimeMS = diffusionTimeMS(2:end);

//% compute the b-values
for ii = 1:length(diffusionTimeMS)
    for jj = 1:length(G)
        b_value(ii,jj) = 1e-9*(gamma*delta*G(jj))^2*(diffusionTimeMS(ii));
    end
end

//% Convert times arguments to stanard units:
diffusionTimeUS = diffusionTimeMS(end)*1000/NSteps; //% ms -> us



//% 4) select number of spins
//%SpinLocations = 'RandomInside';
RWSaddSpins(javaSimulator,numSpinPackets,SpinLocations);

//%MotionResults = RWSsimulate(javaSimulator,timeStepUS,diffusionTimeUS);

SignalAtten = zeros([size(encodingDir,1) length(G) length(diffusionTimeMS)]);
for ii = 1:length(diffusionTimeMS)

    //% 5) simulate the random walks (non-interacting)

    //% 6) read out results

    MotionResults = RWSsimulate(javaSimulator,timeStepUS,diffusionTimeUS);

    tic
    displacement = sqrt(sum(MotionResults.brownianMotion.^2,2));
    displacementx(:,ii) =  MotionResults.brownianMotion(:,1);
    displacementy(:,ii) =  MotionResults.brownianMotion(:,2);
    displacementz(:,ii) =  MotionResults.brownianMotion(:,3);
    rmsd(ii) = sqrt(mean(displacement.^2)); //%um
    rmsd_vec(:,ii) = sqrt([mean(displacementx(:,ii).^2) mean(displacementy(:,ii).^2) mean(displacementz(:,ii).^2)]);

    signal = zeros([size(encodingDir,1) numSpinPackets length(G)]);
    for jj = 1:length(G)
        GradLobeArea = delta*G(jj)/100; //%(mT/cm)*ms
        //% adc and the phase dispersions for all spin packets
        [adc,signal(:,:,jj)] = simulateADC(MotionResults,encodingDir,GradLobeArea);
    end
    //% Calculate the signal attenuation
    SignalAtten(:,:,ii) = squeeze(abs(mean(signal(:,:,:),2)));
    toc

end
adj_rmsd = rmsd/1000; //%mm

if strcmpi(SpinLocations,'RandomOutside')
    D = extraCompartmentDiffusivity; //%mm^2/s
elseif strcmpi(SpinLocations,'RandomInside')
    D = intraCompartmentDiffusivity; //% mm^2/s 
elseif strcmpi(SpinLocations,'Random')
    D = extraCompartmentDiffusivity; //% mm^2/s
end

D = D/1000; //% mm^2/ms
 */