% ====================
% TEST FREE DIFFUSION
% ====================
clear all
clear java
RWSsetup()


% Todo: 
%   create compartments
%       mesh
%       sphere
%       cylinder
%   view meshes w/ lattice

%diffusionModel.Geometry.javaObject = SimCompartmentCylinder(PT(.5,.5,.5), .25,.25, 0,2e-3);
extraComparmentDiffusivity=3e-3;
intraCompartmentDiffusivity=1e-3;
transmissionProbability=0;
center=[1.5 1.5 1.5];
radius=.25;
latticeDimensions = [11 11 11];
numSpinPackets = 100000; %number of packets
%diffusionModel.Geometry(1) = RWScreateCompartmentSphere(intraCompartmentDiffusivity,transmissionProbability,center,radius);
cylinderLength = 10;
% diffusionModel.Geometry{1} = RWScreateCompartmentCylinder(intraCompartmentDiffusivity,transmissionProbability,center,cylinderLength ,radius);
mesh = makeBent;
T2=100e3;
diffusionModel.Geometry{1} = RWScreateCompartmentMesh(T2,intraCompartmentDiffusivity,transmissionProbability,mesh);
% load foo
% diffusionModel.Geometry{1}.javaObject.findFirstIntersection(bl.diffusion.PT(a),bl.diffusion.PT(c))
% return
%.javaObject = SimCompartmentSphere(PT(.5,.5,.5), .333, 0,1e-3);

NSteps=1;
diffusionTimeMS = linspace(0,10,NSteps+1); %ms
diffusionTimeMS =diffusionTimeMS (2:end);
% Convert times arguments to stanard units:
diffusionTimeUS = diffusionTimeMS(end)*1000/NSteps; % ms -> us
timeStepUS = 100; %usa

% 1) Initialize Java Simulator
javaSimulator = RWSnewSimulator(extraComparmentDiffusivity,latticeDimensions,T2);

% 3) Enter the geometries
currentGeometry=[];
for j=1:length(diffusionModel.Geometry)
    [compartmentIndex(j),currentGeometry]=RWSaddCompartment(javaSimulator,diffusionModel.Geometry{j},currentGeometry);
end


% 4) select number of spins
RWSaddSpins(javaSimulator,numSpinPackets,'RandomInside');

if(1)
    for ii = 1:length(diffusionTimeMS)

        % 5) simulate the random walks (non-interacting)

        % 6) read out results

        MotionResults = RWSsimulate(javaSimulator,timeStepUS,diffusionTimeUS);

        displacement = sqrt(sum(MotionResults.brownianMotion.^2,2));
        rmsd(ii) = sqrt(mean(displacement.^2)); %um

        motionInfo = MotionResults;
        encodingDir = [1 0 0; 0 1 0; 0 0 1];
        delta = 16; %ms
        G = 30; %mT/m
        G = G/100; % mT/cm
        GradLobeArea = delta*G; %(mT/cm)*ms
        [adc(ii,:),signal(ii,:,:)] = simulateADC(motionInfo,encodingDir,GradLobeArea);


    end
    %
    %     adj_rmsd = rmsd/1000; %mm
    %
    %     D = diffusionModel.extraComparmentDiffusivity; %mm^2/s
    %     D = D/1000 % mm^2/ms
    %
    %     figure(1); clf
    %     plot(diffusionTimeMS,adj_rmsd,'ro-'), hold on
    %     plot(diffusionTimeMS,sqrt(6*D*diffusionTimeMS),'k*'), hold on
    %     xlabel('diffusionTime in ms')
    %     ylabel('RMSD in mm')
    %     legend('rand walk','sim from known D',0)
    %
    %
    %     figure(2); clf
    %     plot(diffusionTimeMS,adc,'x-'), hold on
    %     plot(diffusionTimeMS,ones(size(diffusionTimeMS))*D*1e3,'-*'), hold on
    %     xlabel('diffusionTime in ms')
    %     ylabel('ADC in um^2/um')
    %     legend('ADC_x','ADC_y','ADC_z','known D',0)

end

figure(1);clf
a=javaSimulator.reportResultPositions
plot3(a(:,1),a(:,2),a(:,3),'.')
hold on; RWSshowGeometry(diffusionModel.Geometry,latticeDimensions)

a=javaSimulator.reportOriginalPositions
figure(2);clf
plot3(a(:,1),a(:,2),a(:,3),'.')
hold on; RWSshowGeometry(diffusionModel.Geometry,latticeDimensions)

x=MotionResults.brownianMotion(:,1);
[Fx,Xx]=ksdensity([x' -x'],'kernel','triangle');
x=MotionResults.brownianMotion(:,2);
[Fy,Xy]=ksdensity([x' -x'],'kernel','triangle');
x=MotionResults.brownianMotion(:,3);
[Fz,Xz]=ksdensity([x' -x'],'kernel','triangle');
figure, plot(Xx,Fx,Xy,Fy,Xz,Fz)