function compartmentGeometry = RWScreateCompartmentAffineTransform(T2,intraCompartmentDiffusivity,membranePermeability,affineTransform,compartment)
% function compartmentGeometry  =
% RWScreateCompartmentUnion(intraCompartmentDiffusivity,transmissionProbability,affineTransform,compartment)
%
%   Create a restriction environment based on the affine transform of an
%   existing compartment.
%
%   Inputs:
%       T2 - T2 of the compartment in us
%       intraCompartmentDiffusivity - intra-compartment diffusivity um2/us
%       membranePermeability - um/us
%       affineTransform - a 4x4 matrix defining the transform of the compartment 
%       compartment - existing RWS compartment object
%
%   Outputs:
%       compartmentGometry - an object to describe the compartment
%       geometry.
% ***********************************************
% RandomWalkSimulator v2.0
% Major Revision by:
% 	Bennett Landman, landman@jhu.edu
% 	Jonathan Farrell, jfarrell@jhu.edu
%   (C) Copyright 2008, Bennett Landman and Jonathan Farrell
%   Released under Lessor GNU Public License v1.0
% 	Not for clinical use.
% 	No warranty expressed or implied.
%   Use at your own risk.
% Download at: http://www.nitrc.org/projects/randomwalks/
% ***********************************************
% 1/22/09 bl

import bl.diffusion.*;

% bug fix by jfarrell
%compartmentGeometry.javaObject = SimCompartmentIntersection(transmissionProbability,intraCompartmentDiffusivity);
compartmentGeometry.javaObject = SimCompartmentTransform(compartment.javaObject,affineTransform,T2,membranePermeability,intraCompartmentDiffusivity);
compartmentGeometry.name= 'Transform';
compartmentGeometry.diffusivity=intraCompartmentDiffusivity;
compartmentGeometry.permeability=membranePermeability;

   
    MX=max(compartment.shape.vertices);
    MN=min(compartment.shape.vertices);
    v=compartment.shape.vertices;v(:,4)=1;
    vv=affineTransform*v';
    MX=max(vv(1:3,:)');
    MN=min(vv(1:3,:)');
mx = max(MX,[],1)+.1*max(MX(:)-MN(:));
mn = min(MN,[],1)-.1*max(MX(:)-MN(:));

    [X,Y,Z]=ndgrid(linspace(mn(1),mx(1),51),...
        linspace(mn(2),mx(2),51),...
        linspace(mn(3),mx(3),51)...
        );
    mask = X;
    for i=1:size(X,1)
        for j=1:size(X,2)
            for k=1:size(X,3)
                mask(i,j,k)=compartmentGeometry.javaObject.contains(PT(X(i,j,k),Y(i,j,k),Z(i,j,k)));
            end
        end
    end
    
 V = smooth3(...     
     mask);
     
 compartmentGeometry.shape=isosurface(X,Y,Z,V  ,0.5);
%  figure(99);clf;patch(compartmentGeometry.shape,'facecolor','r','edgecolor','none');light;lighting phong

