function compartmentGeometry = RWScreateCompartmentCylinder(T2, intraCompartmentDiffusivity,membranePermeability,center,radius,length)
% function compartmentGeometry  =
% RWScreateCompartmentCylinder(intraCompartmentDiffusivity,membranePermeability,center,radius,length,T2)
%
%   Create a cylindrical restriction environment oriented along the
%   z-axis.
%
%   Inputs:
%       T2 - T2 of the compartment in us
%       intraCompartmentDiffusivity - intra-compartment diffusivity um2/us
%       membranePermeability - um/us
%       center - center of the sphere in um (does not need to be within lattice)
%       radius - radius of the sphere in um
%       length - length of the cylinder in um.
%
%   Outputs:
%       compartmentGometry - an object to describe the compartment
%       geometry.
% ***********************************************
% RandomWalkSimulator v2.0
% Major Revision by:
% 	Bennett Landman, landman@jhu.edu
% 	Jonathan Farrell, jfarrell@jhu.edu
%   (C) Copyright 2008, Bennett Landman and Jonathan Farrell
%   Released under Lessor GNU Public License v1.0
% 	Not for clinical use.
% 	No warranty expressed or implied.
%   Use at your own risk.
% Download at: http://www.nitrc.org/projects/randomwalks/
% ***********************************************
% 9/11/08 bl

import bl.diffusion.*;
compartmentGeometry.javaObject = SimCompartmentCylinder(PT(center(1),center(2),center(3)), radius, length, membranePermeability,intraCompartmentDiffusivity,T2);
compartmentGeometry.name= 'Cylinder (analytic)';
compartmentGeometry.diffusivity=intraCompartmentDiffusivity;
compartmentGeometry.permeability=membranePermeability;
if(1)
    [X,Y,Z]=ndgrid(linspace(center(1)-radius-0.1,center(1)+radius+.1,21),...
        linspace(center(2)-radius-.1,center(2)+radius+.1,21),...
        linspace(center(3)-length/2-.1,center(3)+length/2+.1,21));
    V = smooth3(...
        smooth3(...
        (sqrt((X-center(1)).^2+(Y-center(2)).^2)<=radius)...
        .*(abs(Z-center(3))<length/2)...
        ));
    compartmentGeometry.shape=isosurface(X,Y,Z,V,0.5);
else
    N=21;
    th = linspace(0,2*pi,N);
    [x,y] = pol2cart(th,radius);

    shape.vertices = [[x x]'+center(1) [y y]'+center(2) [repmat(-length/2,size(x)) repmat(length/2,size(x))]'+center(3)];
    shape.faces = [];
    for j=0:(N-1)
        shape.faces(end+1,:) = 1+[j mod(j+1,N) j+N];
    end

    for j=0:(N-1)
        shape.faces(end+1,:) = 1+[j+N N+mod(j+1,N) j+1];
    end

    for j=2:(N-1)
        shape.faces(end+1,:) = 1+[0 j-1 j];
        shape.faces(end+1,:) = 1+[N+0 N+j-1 N+j];
    end
    compartmentGeometry.shape=shape;
end