function finiteGradientModel = RWScreateFiniteGradient(samplingRate,arbitraryWaveform)
% function finiteGradientModel  =
% RWScreateFiniteGradient(samplingRate,arbitraryWaveform)
%
%   Create a discritized model of a finite gradient waveform.
%
%   Inputs:
%       samplingRate - (scalar) time index of waveform's sampling rate in us/sample. The first
%       sample occurs between [0,samplingRate), the second between
%       [samplingRate,2*samplingRate), etc.
%
%       arbitraryWaveform - (3xN) vector of gradient strength in mT/m along x, y, and z
%       respectively. For any time after N*samplingRate, the gradient is
%       assumed to be 0.
%
%   Outputs:
%       finiteGradientModel - an object to describe the model.
%
% ***********************************************
% RandomWalkSimulator v2.1
% Major Revision by:
% 	Bennett Landman, landman@jhu.edu
% 	Jonathan Farrell, jfarrell@jhu.edu
%   (C) Copyright 2008, Bennett Landman and Jonathan Farrell
%   Released under Lessor GNU Public License v1.0
% 	Not for clinical use.
% 	No warranty expressed or implied.
%   Use at your own risk.
% Download at: http://www.nitrc.org/projects/randomwalks/
% ***********************************************
% 5/11/09 bl

finiteGradientModel.samplingRate = samplingRate;
finiteGradientModel.arbitraryWaveform = arbitraryWaveform;
