function shapeprune = RWSlatticePrune(shape,lattice)
% function shapeprune = RWSlatticePrune(shape,lattice)
%
%   Prune (remove) any faces from a patch object that 
%   lie wholely outside of the repeating lattice. 
%
%   Inputs:
%       shape - Matlab shape object for the patch command (vertex positions
%           must be listed in um)
%       lattice - a 3x1 vector of the lattice dimensions (in um)
%
%   Outputs:
%       shapeprune - a shape object with a reduced number of faces. 
%
% ***********************************************
% RandomWalkSimulator v2.0
% Major Revision by:
% 	Bennett Landman, landman@jhu.edu
% 	Jonathan Farrell, jfarrell@jhu.edu
%   (C) Copyright 2008, Bennett Landman and Jonathan Farrell
%   Released under Lessor GNU Public License v1.0
% 	Not for clinical use.
% 	No warranty expressed or implied.
%   Use at your own risk.
% Download at: http://www.nitrc.org/projects/randomwalks/
% ***********************************************
% 9/17/08 bl
valid=ones([size(shape.faces,1) 1]);
tags = [shape.vertices(:,1)<0 shape.vertices(:,2)<0 shape.vertices(:,3)<0 ...
    shape.vertices(:,1)>lattice(1) shape.vertices(:,2)>lattice(2) shape.vertices(:,3)>lattice(3)];
corners = [1 2 3; 2 3 4; 2 4 6; 1 2 6; 1 3 5; 1 6 5;3 5 4]; % not used yet.
for j=1:size(tags,2)
%t1 = tags(:,corners(j,1)); t2 = tags(:,corners(j,2)); t3 = tags(:,corners(j,3));
%valid=valid.*(3>sum((t1(shape.faces)+t2(shape.faces)+t3(shape.faces))>0,2));
t = tags(:,j);
valid=valid.*(3>sum((t(shape.faces)),2));

end
shapeprune.vertices = shape.vertices;
shapeprune.faces = shape.faces(find(valid),:);