function javaSimulator = RWSnewSimulator(extraComparmentDiffusivity,latticeDimensions, T2)
% function RWSnewSimulator(extraComparmentDiffusivity,latticeDimensions)
% 
%   Allocate a new java-based random walk simulator.
%
%   Inputs: 
%       extraComparmentDiffusivity - um2/us
%       latticeDimensions - dimensions of infinitely repeating unit space
%           3x1 vector (um)
%       extraCompartmentT2 - us
%
% ***********************************************
% RandomWalkSimulator v2.0
% Major Revision by: 
% 	Bennett Landman, landman@jhu.edu
% 	Jonathan Farrell, jfarrell@jhu.edu
%   (C) Copyright 2008, Bennett Landman and Jonathan Farrell
%   Released under Lessor GNU Public License v1.0
% 	Not for clinical use.
% 	No warranty expressed or implied.
%   Use at your own risk.
% Download at: http://www.nitrc.org/projects/randomwalks/
% ***********************************************
% 9/10/08 bl
import bl.diffusion.*;
try 
    javaSimulator = RandomWalkSimulator;
catch
    error('Unable to import Java resources');
end
javaSimulator.intenseDebug=0;

javaSimulator.setLatticeInfo(extraComparmentDiffusivity, ... %UM2pUS
    latticeDimensions(1),...%um
    latticeDimensions(2),... %um
    latticeDimensions(3),... %um
    T2); %us

