function RWSsetCompartmentInside(javaSimulator,interiorCompartmentIndex,exteriorComparmentIndex)
% function RWSsetCompartmentInside(javaSimulator,interiorCompartmentIndex,exteriorComparmentIndex)
% 
%   Set the inside/outside relationship between compartments that have
%   already been added to the RWS simulator. These indecies are returned
%   when a compartment is added to the RWS.
%
%   Inputs:
%       javaSimulator - RWS simulator object
%       interiorCompartmentIndex  - index of compartment that is inside
%       exteriorComparmentIndex - index of compartment that is outside
%
% ***********************************************
% RandomWalkSimulator v2.0
% Major Revision by: 
% 	Bennett Landman, landman@jhu.edu
% 	Jonathan Farrell, jfarrell@jhu.edu
%   (C) Copyright 2008, Bennett Landman and Jonathan Farrell
%   Released under Lessor GNU Public License v1.0
% 	Not for clinical use.
% 	No warranty expressed or implied.
%   Use at your own risk.
% Download at: http://www.nitrc.org/projects/randomwalks/
% ***********************************************
% 9/10/08 bl


import bl.diffusion.*;
javaSimulator.setCompartmentOutsideInside(exteriorComparmentIndex,interiorCompartmentIndex);