function RWSsetFiniteGradients(javaSimulator,finiteGradientModels)
% function RWSaddCompartment(javaSimulator,finiteGradientModels)
%
%   Sets the finite gradient models for use in the simulations. 
%   Replaces any current models in use. 
%
%   Inputs:
%       javaSimulator - RWS simulator object
%       finiteGradientModels - a list of finite gradient model object. 
%           e.g., see RWScreateFiniteGradient.m
%
% ***********************************************
% RandomWalkSimulator v2.1
% Major Revision by:
% 	Bennett Landman, landman@jhu.edu
% 	Jonathan Farrell, jfarrell@jhu.edu
%   (C) Copyright 2008, Bennett Landman and Jonathan Farrell
%   Released under Lessor GNU Public License v1.0
% 	Not for clinical use.
% 	No warranty expressed or implied.
%   Use at your own risk.
% Download at: http://www.nitrc.org/projects/randomwalks/
% ***********************************************
% 5/11/09 bl 

import bl.diffusion.*;
javaSimulator.setNumberFiniteGradients(length(finiteGradientModels));
if(~isempty(finiteGradientModels))
    for i=1:length(finiteGradientModels)
        model = bl.diffusion.SimFGArbitraryWaveform(finiteGradientModels(i).samplingRate,finiteGradientModels(i).arbitraryWaveform');
        javaSimulator.setFiniteGradient(i-1,model);
    end
end
