% Figure 1.A
clear all;
spacing = 1;
latticeDimensions = [10 10 10];
SpinLocations = 'Random';
DT = [1 20 100];
figure(1);
clf;
NJ=25;
for jDT = 1:length(DT)
    MaxDiffusionTimeMS = DT(jDT); % maximum diffusion time in ms
    numSpinPackets = 100000;
    timesteps=MaxDiffusionTimeMS./round(logspace(0,3,11));
    
    for ti=1:length(timesteps)
        timestep=timesteps(ti);
        cyl_rad = 1.5;
        steps(ti) = round(MaxDiffusionTimeMS/timestep);
        
        spins(ti) = numSpinPackets/steps(ti);
        tic;
        for j=1:NJ
            [b_value,diffusionTimeMS,MotionResults,...
                displacementx,displacementy,displacementz,rmsd_vec,adj_rmsd,D]= ...
                nmr09freediffusion(spins(ti),MaxDiffusionTimeMS*1000/steps(ti),latticeDimensions,SpinLocations,MaxDiffusionTimeMS);
              figure, hist(log(MotionResults.T2SignalAttenuation),100)
%             pause
            x=linspace(-50,50,100); y=interp1([-1000 sort(displacementx)' 1000],[0 linspace(0,1,length(displacementx)) 1],x);
            ytrue=.5*(1+erf(x/1000/sqrt(2)/sqrt(2*D*MaxDiffusionTimeMS)));
            err(ti,j,jDT)=sqrt(trapz(x,(ytrue-y).^2));
        end
        %         MR{ti}=MotionResults;
        %     hold on; plot(x,y,x,.5*(1+erf(x/1000/sqrt(2)/sqrt(2*D*20))));
        %     pause;
    end
end
s = {'k-','k-.','k:'}
figure(1);clf;
for jDT=1:size(err,3)
    h(jDT)=errorbar(log(steps),mean(err(:,:,jDT),2),std(err(:,:,jDT),[],2)/sqrt(NJ),s{jDT})
    hold on;
end
legend(h,'1 ms','20 ms','100 ms')
xlabel('# of time steps');
ylabel('RMSE');
set(gca,'xtick',log(steps));set(gca,'xticklabel',(steps));
a=axis;
a(1)=-.25;
axis(a)