% Figure 1.A
% clear java;
% clear all;
spacing = 1;
latticeDimensions = [11 11 11];
SpinLocations = 'RandomInside';
DT = 100;
figure(1);
clf;
NJ=2;
CR = [1]; %um
[X,Y]=ndgrid(linspace(-100,100,100),linspace(-100,100,100));
C = (X.^2+Y.^2)<100^2;
a=conv2(C+0,C+0);
yc=(a(100,:));
NSTEPS = fliplr([5 10 20 50 100 200 500 1000 2000 5000 10000]);% 20 50 100 200 500 1000];
for jCR = 1:length(CR)
    cyl_rad = CR(jCR);
    xc = linspace(-2*cyl_rad ,2*cyl_rad,length(yc));
    yc=yc./trapz(xc,yc)
    Fc = cumtrapz(xc,yc);
    for jDT = 1
        MaxDiffusionTimeMS = DT(jDT); % maximum diffusion time in ms
        numSpinPackets = 10000;
        %         timesteps=MaxDiffusionTimeMS./round(logspace(1,3,11));
        
        for ti=1:length(NSTEPS)
            timestep=round(MaxDiffusionTimeMS/NSTEPS(ti))%timesteps(ti);
            steps(ti) = NSTEPS(ti);%round(MaxDiffusionTimeMS/timestep);
            
            spins(ti) = numSpinPackets;
            tic;
            for j=1:NJ
                t=now;
                [b_value,diffusionModel,diffusionTimeMS,MotionResults,...
                    displacementx,displacementy,displacementz,rmsd_vec,adj_rmsd,D] ...
                    ...%                     nmr09freediffusion(spins(ti),MaxDiffusionTimeMS*1000/steps(ti),latticeDimensions,SpinLocations,MaxDiffusionTimeMS);
                    = nmr09cylinder(cyl_rad,spins(ti),MaxDiffusionTimeMS*1000/steps(ti),latticeDimensions,SpinLocations,MaxDiffusionTimeMS);
                y=interp1([-1000 sort([displacementx' -displacementx']) 1000],[0 2*linspace(0,1,length(displacementx)) 1],xc);
                %                 ytrue=.5*(1+erf(x/1000/sqrt(2)/sqrt(2*D*MaxDiffusionTimeMS)));
                mytime(ti,j,jCR) = now-t;
                figure(2);
                pause(.1)
                plot(xc,y,xc,Fc)
                title([jCR ti j])
                drawnow;
                err(ti,j,jCR)=sqrt(trapz(xc,(Fc-y).^2));
            end
            %         MR{ti}=MotionResults;
            %     hold on; plot(x,y,x,.5*(1+erf(x/1000/sqrt(2)/sqrt(2*D*20))));
            %     pause;
        end
    end
end
save nrm09control_b2
s = {'k-','k-.','k:'}
figure(1);clf;
for jDT=1:size(err,3)
    h(jDT)=errorbar(log(steps),mean(err(:,:,jDT),2),std(err(:,:,jDT),[],2)/sqrt(NJ),s{jDT})
    hold on;
end
legend(h,'2 \mum')
xlabel('# of time steps');
ylabel('RMSE');
set(gca,'xtick',log(steps));set(gca,'xticklabel',(steps));
a=axis
a(1)=log(steps(1))-.25;
axis(a);