function [diffusionModel,diffusionTimeMS,MotionResults,displacementx,displacementy,displacementz,rmsd_vec,adj_rmsd,D]= ...
    nmr09cylinderFG(cyl_rad,numSpinPackets,timestep,latticeDimensions,SpinLocations,MaxDiffusionTimeMS,b_value,grads)

% clc;
%close all;
%clear all
try
RWSsetup()
catch
RWSsetup()
end

extraCompartmentDiffusivity=2e-3;
intraCompartmentDiffusivity=2e-3;
transmissionProbability=0;
%LD = 3;
%latticeDimensions = [LD LD LD];
cylinderLength = 3*latticeDimensions(3);
%cyl_rad = 1.4;
%sph_rad = 0;
%numSpinPackets = 100; %number of packets
NSteps = 1; % number of diffusion time steps

timeStepUS = timestep; %us 20us timestep,D = 2e-3,root(6DtimeStep) = 0.5um, step.  

% parameters for diffusion weighting experiment
T2 = 100e3;%us
center=latticeDimensions/2;
diffusionModel.Geometry{1} = RWScreateCompartmentCylinder(T2,intraCompartmentDiffusivity,transmissionProbability,center,cyl_rad,cylinderLength);;
% unit_center_cyl_spheres(T2,latticeDimensions,cylinderLength,cyl_rad,sph_rad,intraCompartmentDiffusivity,transmissionProbability,flag);



diffusionTimeMS = linspace(0,MaxDiffusionTimeMS,NSteps+1); %ms
diffusionTimeMS = diffusionTimeMS(2:end);

% compute the b-values
% for ii = 1:length(diffusionTimeMS)
%     for jj = 1:length(G)
%         b_value(ii,jj) = 1e-9*(gamma*delta*G(jj))^2*(diffusionTimeMS(ii));
%     end
% end

% Convert times arguments to stanard units:
diffusionTimeUS = diffusionTimeMS(end)*1000/NSteps; % ms -> us

% 1) Initialize Java Simulator
javaSimulator = RWSnewSimulator(extraCompartmentDiffusivity,latticeDimensions,T2);
javaSimulator.intenseDebug=0;

% 3) Enter the geometries
currentGeometry=[];
for j=1:length(diffusionModel.Geometry)
    [compartmentIndex(j),currentGeometry]=RWSaddCompartment(javaSimulator,diffusionModel.Geometry{j},currentGeometry);
end

% 4) select number of spins
%SpinLocations = 'RandomInside';
RWSaddSpins(javaSimulator,numSpinPackets,SpinLocations);

%MotionResults = RWSsimulate(javaSimulator,timeStepUS,diffusionTimeUS);
gamma = 267.52e6; % rad s-1 T-1
% b = (gamma d G)^2 (D-d/3)
% sqrt([s/mm2/s]) *us-1 * s T * 1e6 --> mT/m
delta = 1e-6*diffusionTimeUS/2
% delta = timestep;
% Delta = diffusionTimeUS;
Delta = 1e-6*diffusionTimeUS/2
b_value_sm2 = b_value*1e6; % s/mm2 -> s/m2
% q = gamma*G*delta/2/pi;
% G = sqrt(b_value_sm2/(Delta-delta/3))/delta/gamma
Delta_s=Delta;
delta_s=delta;
G = sqrt(b_value/(Delta_s-delta_s/3))/gamma/delta_s * 1e6;
% G =
% sqrt(b_value/(1e-6*(diffusionTimeUS/2-diffusionTimeUS/3)))/(1e-6*diffusionTimeUS/2*gamma)*1e6

% bb = (gamma*delta*G)^2*(Delta-delta/3)
for i=1:size(grads,1)
    waveform = zeros([1000 3]);
    for k=1:3
    waveform(1:500,k)=G*grads(i,k); % mT/m 
    waveform(501:end,k)=-G*grads(i,k); % mT/m 
    end
    samplingRate = diffusionTimeUS/1000;
    FG(i)=RWScreateFiniteGradient(samplingRate,waveform);
end
RWSsetFiniteGradients(javaSimulator,FG)

for ii = 1:length(diffusionTimeMS)

    % 5) simulate the random walks (non-interacting)

    % 6) read out results

    MotionResults = RWSsimulate(javaSimulator,timeStepUS,diffusionTimeUS);
    
    tic
    displacement = sqrt(sum(MotionResults.brownianMotion.^2,2));
    displacementx(:,ii) =  MotionResults.brownianMotion(:,1);
    displacementy(:,ii) =  MotionResults.brownianMotion(:,2);
    displacementz(:,ii) =  MotionResults.brownianMotion(:,3);
    rmsd(ii) = sqrt(mean(displacement.^2)); %um
    rmsd_vec(:,ii) = sqrt([mean(displacementx(:,ii).^2) mean(displacementy(:,ii).^2) mean(displacementz(:,ii).^2)]);
    
%     signal = zeros([size(encodingDir,1) numSpinPackets length(G)]);
%     for jj = 1:length(G)
%         GradLobeArea = delta*G(jj)/100; %(mT/cm)*ms
%         % adc and the phase dispersions for all spin packets
%         [adc,signal(:,:,jj)] = simulateADC(MotionResults,encodingDir,GradLobeArea);
%     end
%     % Calculate the signal attenuation
%     SignalAtten(:,:,ii) = squeeze(abs(mean(signal(:,:,:),2)));
%     toc
        
end
adj_rmsd = rmsd/1000; %mm

if strcmpi(SpinLocations,'RandomOutside')
    D = extraCompartmentDiffusivity; %mm^2/s
elseif strcmpi(SpinLocations,'RandomInside')
    D = intraCompartmentDiffusivity; % mm^2/s 
elseif strcmpi(SpinLocations,'Random')
    D = extraCompartmentDiffusivity; % mm^2/s
end

D = D/1000; % mm^2/ms
