spacing = 1;
latticeDimensions = [10 10 20];
numSpinPackets = 100000;
times = [2 20];
SpinLocations = 'RandomInside';
clear MR
for jIter=1:25
    for jTime=1:length(times)
        
        
        MaxDiffusionTimeMS = times(jTime); % maximum diffusion time in ms
        
        timeStepUS = MaxDiffusionTimeMS/250*1000;
        cyl_rad = 1.5;
        tic;
        sprintf('Cylinder - %d ms at %d',MaxDiffusionTimeMS,jIter)
        [b_value,SignalAtten,diffusionModel,diffusionTimeMS,MotionResults,...
            displacementx,displacementy,displacementz,rmsd_vec,adj_rmsd,D]= ismrm09cylinderNMR(timeStepUS,cyl_rad,numSpinPackets,latticeDimensions,SpinLocations,MaxDiffusionTimeMS);
        totaltime=toc;
        for i=1:length(diffusionModel.Geometry)
            diffusionModel.Geometry{i}.javaObject=0;
        end
        %         clear diffusionModel
        MR{1,jTime,jIter}=MotionResults;
        cyl_rad = 1.5;
        sph_rad = 4;
        tic;
        sprintf('Bulge - %d ms at %d',MaxDiffusionTimeMS,jIter)
        [b_value,SignalAtten,diffusionModel,diffusionTimeMS,MotionResults,...
            displacementx,displacementy,displacementz,rmsd_vec,adj_rmsd,D]= ismrm09bulgeNMR(timeStepUS,cyl_rad,sph_rad,numSpinPackets,latticeDimensions,SpinLocations,MaxDiffusionTimeMS);
        % RWSshowGeometry(diffusionModel.Geometry,latticeDimensions)
        totaltime=toc;
        for i=1:length(diffusionModel.Geometry)
            diffusionModel.Geometry{i}.javaObject=0;
        end
        %         clear diffusionModel
        MR{2,jTime,jIter}=MotionResults;
        cyl_rad = 1.5;
        sph_rad = 4;
        tic;
        sprintf('Crimp - %d ms at %d',MaxDiffusionTimeMS, jIter)
        [b_value,SignalAtten,diffusionModel,diffusionTimeMS,MotionResults,...
            displacementx,displacementy,displacementz,rmsd_vec,adj_rmsd,D]= ismrm09crimpNMR(timeStepUS,cyl_rad,sph_rad,numSpinPackets,latticeDimensions,SpinLocations,MaxDiffusionTimeMS);
        totaltime=toc;
        % RWSshowGeometry(diffusionModel.Geometry,latticeDimensions)
        for i=1:length(diffusionModel.Geometry)
            diffusionModel.Geometry{i}.javaObject=0;
        end
        MR{3,jTime,jIter}=MotionResults;
        
        cyl_rad = 1.5;
        cylinderLength = latticeDimensions(3)*.75;
        sph_rad = 4;
        tic;
        sprintf('Broken - %d ms at %d',MaxDiffusionTimeMS,jIter)
        [b_value,SignalAtten,diffusionModel,diffusionTimeMS,MotionResults,...
            displacementx,displacementy,displacementz,rmsd_vec,adj_rmsd,D]= ismrm09brokenNMR(timeStepUS,cyl_rad,cylinderLength,numSpinPackets,latticeDimensions,SpinLocations,MaxDiffusionTimeMS);
        totaltime=toc;
        % RWSshowGeometry(diffusionModel.Geometry,latticeDimensions)
        for i=1:length(diffusionModel.Geometry)
            diffusionModel.Geometry{i}.javaObject=0;
        end
        MR{4,jTime,jIter}=MotionResults;
    end
end