function showADC3DImages(motionResults, handles)
% showADC3DImages -- show 3d emperical diffusion profile (internal use)
%   showADC3DImages(motionResults, handles)
%       motionResults - results from simulator
%       handles - MRMproject GUI handles (used to exchange data)
%
% Copyright (C) 2005 Bennett Landman, bennett@bme.jhu.edu
% History: MRM Final Project: 12/1/05

% Step 1. Get the ADC and Grad data
adc = get(handles.ADC,'UserData');
grad = get(handles.diffusionWeightingFile,'userdata');

% Step 2. Normalize teh gradients and create a triangulation of arbitrary
% points (since we know that they are on a sphere, a convex hull will 
% properly tesselate the surface)
[th,ph,r] = cart2sph(grad(:,1),grad(:,2),grad(:,3));
[x0,y0,z0] = sph2cart(th,ph,ones(size(th))); %adc');
[x,y,z] = sph2cart(th,ph,adc'./max(adc(:))); %adc');
grad = [x y z];
grad0 = [x0 y0 z0];
K = convhulln([grad0; -grad0]);

% Step 3. Display the convex hull mesh (K) with the radial distances
% scaled by the adc
h = patch('vertices',[grad; -grad],'faces',K,'facecolor','yellow');
set(h,'edgecolor','none');
axis equal ;
axis tight;

adc2 = [adc adc]./max(adc);
adc2 = round(adc2*255)+1;
cmap  = pink(310);
set(h,'FaceVertexCData',cmap(adc2,:))
set(h,'facecolor','interp')
set(gcf,'color','white')
axis off
set(h,'EdgeColor','white');

% Step 4. Show a little animation.
busy
for i=0:180
    view(i,30);
    pause(.01);
end
idle