function [x,xvec,V2Dproj,C2Dproj,C] = simAxonsQspace_convolutions(R,shape)

len = 2*R;

N = 200;
[XX,YY]=ndgrid(linspace(-3*R,3*R,N));
% circle
if strcmpi(shape,'circle')
    V = double(sqrt(XX.^2+YY.^2)<R);
% square
elseif strcmpi(shape,'square')
    V1 = double(abs(XX)<len/2);
    V2 = double(abs(YY)<len/2);
    V = V1.*V2; 
elseif strcmpi(shape,'gaussian')
    y = normpdf(XX(:,1),0,len);
    V = conv2(y,y');
end

V2Dproj = V(N/2,:);

C = conv2(V,V);
C2Dproj = C(N,:);

x = linspace(-3*R,3*R,N);
Const = trapz(x,V2Dproj);
V2Dproj = V2Dproj/Const;

xvec = linspace(-2*3*R,2*3*R,length(C2Dproj));
Const = trapz(xvec,C2Dproj);
C2Dproj = C2Dproj/Const;

PDF = C2Dproj;
dist = xvec;
PZERO = max(PDF(:));
HM = 0.5*PZERO;
interp_PDF = interp(PDF,10);
interp_dist = interp(dist,10);
[val,ind] = min(abs(interp_PDF-HM));
FWHM = 2*abs(interp_dist(ind));
RMSD = sqrt(trapz(dist,PDF.*dist.^2));

 %figure(1), imshow(C)
 %figure(2), plot(x,V2Dproj,'b*-'); hold on
 %figure(2), plot(xvec,C2Dproj,'ro-'); hold on