clear all
try
RWSsetup()
catch
RWSsetup()
end

%diffusionModel.Geometry.javaObject = SimCompartmentCylinder(PT(.5,.5,.5), .25,.25, 0,2e-3);
extraComparmentDiffusivity=3e-3;
intraCompartmentDiffusivity=1e-3;
transmissionProbability=0;
center=[3 3 3];
radius=1;
latticeDimensions = [6 6 6];
numSpinPackets = 1000; %number of packets

% use the union method
cylinderLength = 13;
radius = 1.4;
diffusionModel.Geometry{1} = RWScreateCompartmentSphere(intraCompartmentDiffusivity,transmissionProbability,center,radius);
radius = 0.5;
diffusionModel.Geometry{2} = RWScreateCompartmentCylinder(intraCompartmentDiffusivity,transmissionProbability,center,radius,cylinderLength);
diffusionModel.latticeDimensions = latticeDimensions;
diffusionModel.name = [];
U = RWScreateCompartmentUnion(intraCompartmentDiffusivity,transmissionProbability,diffusionModel.Geometry{1},diffusionModel.Geometry{2});
I = RWScreateCompartmentIntersection(intraCompartmentDiffusivity,transmissionProbability,diffusionModel.Geometry{1},diffusionModel.Geometry{2});

figure(1)
subplot(2,1,1)
RWSshowGeometry(diffusionModel.Geometry,diffusionModel.latticeDimensions)
UniondiffusionModel.Geometry{1} = U;
UniondiffusionModel.latticeDimensions = latticeDimensions;
subplot(2,1,2)
RWSshowGeometry(UniondiffusionModel.Geometry,UniondiffusionModel.latticeDimensions)

figure(2)
subplot(2,1,1)
RWSshowGeometry(diffusionModel.Geometry,diffusionModel.latticeDimensions)
IntersectiondiffusionModel.Geometry{1} = I;
IntersectiondiffusionModel.latticeDimensions = latticeDimensions;
subplot(2,1,2)
RWSshowGeometry(IntersectiondiffusionModel.Geometry,IntersectiondiffusionModel.latticeDimensions)