function ABCD = fitPlane(x,y,z)
% function ABCD = fitPlane(x,y,z)
% 
% Fit a plane to a set of three points.
% This has NOT been updated to handle a best-fit plane.
%
% (C)opyright 2005, Bennett Landman, bennett@bme.jhu.edu
% Revision History:
% Created: 2/11/2005
ABCD(1) = y(1)* (z(2) - z(3)) + y(2)* (z(3) - z(1)) + y(3)* (z(1) - z(2)) ;
ABCD(2) = z(1)* (x(2) - x(3)) + z(2)* (x(3) - x(1)) + z(3)* (x(1) - x(2)) ;
ABCD(3)= x(1)* (y(2) - y(3)) + x(2)* (y(3) - y(1)) + x(3)* (y(1) - y(2)) ;
ABCD(4) = -1*(x(1)* (y(2)*z(3) - y(3)*z(2)) + x(2)*(y(3)*z(1) - y(1)*z(3)) + x(3)*(y(1)*z(2) - y(2)*z(1)));